@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.applicationinsights.kotlin

import com.pulumi.aws.applicationinsights.ApplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ApplicationInsights Application resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourcegroups.Group;
 * import com.pulumi.aws.resourcegroups.GroupArgs;
 * import com.pulumi.aws.resourcegroups.inputs.GroupResourceQueryArgs;
 * import com.pulumi.aws.applicationinsights.Application;
 * import com.pulumi.aws.applicationinsights.ApplicationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .resourceQuery(GroupResourceQueryArgs.builder()
 *                 .query(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("ResourceTypeFilters", jsonArray("AWS::EC2::Instance")),
 *                         jsonProperty("TagFilters", jsonArray(jsonObject(
 *                             jsonProperty("Key", "Stage"),
 *                             jsonProperty("Values", jsonArray("Test"))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .resourceGroupName(exampleGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ApplicationInsights Applications using the `resource_group_name`. For example:
 * ```sh
 *  $ pulumi import aws:applicationinsights/application:Application some some-application
 * ```
 * @property autoConfigEnabled Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
 * @property autoCreate Configures all of the resources in the resource group by applying the recommended configurations.
 * @property cweMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
 * @property groupingType Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
 * @property opsCenterEnabled When set to `true`, creates opsItems for any problems detected on an application.
 * @property opsItemSnsTopicArn SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
 * @property resourceGroupName Name of the resource group.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ApplicationArgs(
    public val autoConfigEnabled: Output<Boolean>? = null,
    public val autoCreate: Output<Boolean>? = null,
    public val cweMonitorEnabled: Output<Boolean>? = null,
    public val groupingType: Output<String>? = null,
    public val opsCenterEnabled: Output<Boolean>? = null,
    public val opsItemSnsTopicArn: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.applicationinsights.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.applicationinsights.ApplicationArgs =
        com.pulumi.aws.applicationinsights.ApplicationArgs.builder()
            .autoConfigEnabled(autoConfigEnabled?.applyValue({ args0 -> args0 }))
            .autoCreate(autoCreate?.applyValue({ args0 -> args0 }))
            .cweMonitorEnabled(cweMonitorEnabled?.applyValue({ args0 -> args0 }))
            .groupingType(groupingType?.applyValue({ args0 -> args0 }))
            .opsCenterEnabled(opsCenterEnabled?.applyValue({ args0 -> args0 }))
            .opsItemSnsTopicArn(opsItemSnsTopicArn?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var autoConfigEnabled: Output<Boolean>? = null

    private var autoCreate: Output<Boolean>? = null

    private var cweMonitorEnabled: Output<Boolean>? = null

    private var groupingType: Output<String>? = null

    private var opsCenterEnabled: Output<Boolean>? = null

    private var opsItemSnsTopicArn: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     */
    @JvmName("oedhmrgdwmslsmeh")
    public suspend fun autoConfigEnabled(`value`: Output<Boolean>) {
        this.autoConfigEnabled = value
    }

    /**
     * @param value Configures all of the resources in the resource group by applying the recommended configurations.
     */
    @JvmName("mvyvjymoljwdxdaa")
    public suspend fun autoCreate(`value`: Output<Boolean>) {
        this.autoCreate = value
    }

    /**
     * @param value Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    @JvmName("dodxtygmohrulapp")
    public suspend fun cweMonitorEnabled(`value`: Output<Boolean>) {
        this.cweMonitorEnabled = value
    }

    /**
     * @param value Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
     */
    @JvmName("roajgyfdvmmyjwtc")
    public suspend fun groupingType(`value`: Output<String>) {
        this.groupingType = value
    }

    /**
     * @param value When set to `true`, creates opsItems for any problems detected on an application.
     */
    @JvmName("pqwbahwqfsusskry")
    public suspend fun opsCenterEnabled(`value`: Output<Boolean>) {
        this.opsCenterEnabled = value
    }

    /**
     * @param value SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
     */
    @JvmName("edvjllwrfmidmigw")
    public suspend fun opsItemSnsTopicArn(`value`: Output<String>) {
        this.opsItemSnsTopicArn = value
    }

    /**
     * @param value Name of the resource group.
     * The following arguments are optional:
     */
    @JvmName("opjrblygalaybjgt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("famutxylediyabwe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     */
    @JvmName("xeriifgnwppvtvyv")
    public suspend fun autoConfigEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoConfigEnabled = mapped
    }

    /**
     * @param value Configures all of the resources in the resource group by applying the recommended configurations.
     */
    @JvmName("okyjargumsnfosjy")
    public suspend fun autoCreate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreate = mapped
    }

    /**
     * @param value Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as instance terminated, failed deployment, and others.
     */
    @JvmName("covywvuixcsvsehc")
    public suspend fun cweMonitorEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cweMonitorEnabled = mapped
    }

    /**
     * @param value Application Insights can create applications based on a resource group or on an account. To create an account-based application using all of the resources in the account, set this parameter to `ACCOUNT_BASED`.
     */
    @JvmName("xacxssqaqfpwurwd")
    public suspend fun groupingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupingType = mapped
    }

    /**
     * @param value When set to `true`, creates opsItems for any problems detected on an application.
     */
    @JvmName("lnlcvtgymgjxujjy")
    public suspend fun opsCenterEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opsCenterEnabled = mapped
    }

    /**
     * @param value SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive notifications for updates to the opsItem.
     */
    @JvmName("exscscdyrevamvvj")
    public suspend fun opsItemSnsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opsItemSnsTopicArn = mapped
    }

    /**
     * @param value Name of the resource group.
     * The following arguments are optional:
     */
    @JvmName("uydvcirqubkghjhp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tpkgmmdjscceoxqr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vqbsctkvrhvhkuug")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        autoConfigEnabled = autoConfigEnabled,
        autoCreate = autoCreate,
        cweMonitorEnabled = cweMonitorEnabled,
        groupingType = groupingType,
        opsCenterEnabled = opsCenterEnabled,
        opsItemSnsTopicArn = opsItemSnsTopicArn,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
