@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.AppmeshFunctions.getGatewayRoutePlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getMeshPlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getRoutePlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualGatewayPlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualNodePlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualRouterPlain
import com.pulumi.aws.appmesh.AppmeshFunctions.getVirtualServicePlain
import com.pulumi.aws.appmesh.kotlin.inputs.GetGatewayRoutePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetGatewayRoutePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetMeshPlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetMeshPlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetRoutePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetRoutePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualGatewayPlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualGatewayPlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualNodePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualNodePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualRouterPlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualRouterPlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualServicePlainArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GetVirtualServicePlainArgsBuilder
import com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetMeshResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetRouteResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewayResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualRouterResult
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.appmesh.kotlin.outputs.GetGatewayRouteResult.Companion.toKotlin as getGatewayRouteResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetMeshResult.Companion.toKotlin as getMeshResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetRouteResult.Companion.toKotlin as getRouteResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualGatewayResult.Companion.toKotlin as getVirtualGatewayResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualNodeResult.Companion.toKotlin as getVirtualNodeResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualRouterResult.Companion.toKotlin as getVirtualRouterResultToKotlin
import com.pulumi.aws.appmesh.kotlin.outputs.GetVirtualServiceResult.Companion.toKotlin as getVirtualServiceResultToKotlin

public object AppmeshFunctions {
    /**
     * The App Mesh Gateway Route data source allows details of an App Mesh Gateway Route to be retrieved by its name, mesh_name, virtual_gateway_name, and optionally the mesh_owner.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetGatewayRouteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getGatewayRoute(GetGatewayRouteArgs.builder()
     *             .meshName("test-mesh")
     *             .name("test-route")
     *             .virtualGatewayName("test-gateway")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getGatewayRoute.
     * @return A collection of values returned by getGatewayRoute.
     */
    public suspend fun getGatewayRoute(argument: GetGatewayRoutePlainArgs): GetGatewayRouteResult =
        getGatewayRouteResultToKotlin(getGatewayRoutePlain(argument.toJava()).await())

    /**
     * @see [getGatewayRoute].
     * @param meshName Name of the service mesh in which the virtual gateway exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the gateway route.
     * @param tags Map of tags.
     * @param virtualGatewayName Name of the virtual gateway in which the route exists.
     * @return A collection of values returned by getGatewayRoute.
     */
    public suspend fun getGatewayRoute(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
        virtualGatewayName: String,
    ): GetGatewayRouteResult {
        val argument = GetGatewayRoutePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
            virtualGatewayName = virtualGatewayName,
        )
        return getGatewayRouteResultToKotlin(getGatewayRoutePlain(argument.toJava()).await())
    }

    /**
     * @see [getGatewayRoute].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetGatewayRoutePlainArgs].
     * @return A collection of values returned by getGatewayRoute.
     */
    public suspend fun getGatewayRoute(argument: suspend GetGatewayRoutePlainArgsBuilder.() -> Unit):
        GetGatewayRouteResult {
        val builder = GetGatewayRoutePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGatewayRouteResultToKotlin(getGatewayRoutePlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Mesh data source allows details of an App Mesh Mesh to be retrieved by its name and optionally the mesh_owner.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetMeshArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var simple = AppmeshFunctions.getMesh(GetMeshArgs.builder()
     *             .name("simpleapp")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getMesh.
     * @return A collection of values returned by getMesh.
     */
    public suspend fun getMesh(argument: GetMeshPlainArgs): GetMeshResult =
        getMeshResultToKotlin(getMeshPlain(argument.toJava()).await())

    /**
     * @see [getMesh].
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the service mesh.
     * @param tags Map of tags.
     * @return A collection of values returned by getMesh.
     */
    public suspend fun getMesh(
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetMeshResult {
        val argument = GetMeshPlainArgs(
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getMeshResultToKotlin(getMeshPlain(argument.toJava()).await())
    }

    /**
     * @see [getMesh].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetMeshPlainArgs].
     * @return A collection of values returned by getMesh.
     */
    public suspend fun getMesh(argument: suspend GetMeshPlainArgsBuilder.() -> Unit): GetMeshResult {
        val builder = GetMeshPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMeshResultToKotlin(getMeshPlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Route data source allows details of an App Mesh Route to be retrieved by its name, mesh_name, virtual_router_name, and optionally the mesh_owner.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualService(GetVirtualServiceArgs.builder()
     *             .meshName("test-mesh")
     *             .name("test-route")
     *             .virtualRouterName("test-router")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRoute.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: GetRoutePlainArgs): GetRouteResult =
        getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())

    /**
     * @see [getRoute].
     * @param meshName Name of the service mesh in which the virtual router exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the route.
     * @param tags Map of tags.
     * @param virtualRouterName Name of the virtual router in which the route exists.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
        virtualRouterName: String,
    ): GetRouteResult {
        val argument = GetRoutePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
            virtualRouterName = virtualRouterName,
        )
        return getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())
    }

    /**
     * @see [getRoute].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetRoutePlainArgs].
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: suspend GetRoutePlainArgsBuilder.() -> Unit):
        GetRouteResult {
        val builder = GetRoutePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteResultToKotlin(getRoutePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS App Mesh Virtual Gateway.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AppmeshFunctions.getVirtualGateway(GetVirtualGatewayArgs.builder()
     *             .meshName("mesh-gateway")
     *             .name("example-mesh")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVirtualGateway.
     * @return A collection of values returned by getVirtualGateway.
     */
    public suspend fun getVirtualGateway(argument: GetVirtualGatewayPlainArgs):
        GetVirtualGatewayResult =
        getVirtualGatewayResultToKotlin(getVirtualGatewayPlain(argument.toJava()).await())

    /**
     * @see [getVirtualGateway].
     * @param meshName Name of the service mesh in which the virtual gateway exists.
     * @param name Name of the virtual gateway.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualGateway.
     */
    public suspend fun getVirtualGateway(
        meshName: String,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualGatewayResult {
        val argument = GetVirtualGatewayPlainArgs(
            meshName = meshName,
            name = name,
            tags = tags,
        )
        return getVirtualGatewayResultToKotlin(getVirtualGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualGatewayPlainArgs].
     * @return A collection of values returned by getVirtualGateway.
     */
    public suspend
    fun getVirtualGateway(argument: suspend GetVirtualGatewayPlainArgsBuilder.() -> Unit):
        GetVirtualGatewayResult {
        val builder = GetVirtualGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualGatewayResultToKotlin(getVirtualGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS App Mesh Virtual Node.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualNodeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualNode(GetVirtualNodeArgs.builder()
     *             .meshName("example-mesh")
     *             .name("serviceBv1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVirtualNode.
     * @return A collection of values returned by getVirtualNode.
     */
    public suspend fun getVirtualNode(argument: GetVirtualNodePlainArgs): GetVirtualNodeResult =
        getVirtualNodeResultToKotlin(getVirtualNodePlain(argument.toJava()).await())

    /**
     * @see [getVirtualNode].
     * @param meshName Name of the service mesh in which the virtual node exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the virtual node.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualNode.
     */
    public suspend fun getVirtualNode(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualNodeResult {
        val argument = GetVirtualNodePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getVirtualNodeResultToKotlin(getVirtualNodePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNode].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualNodePlainArgs].
     * @return A collection of values returned by getVirtualNode.
     */
    public suspend fun getVirtualNode(argument: suspend GetVirtualNodePlainArgsBuilder.() -> Unit):
        GetVirtualNodeResult {
        val builder = GetVirtualNodePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNodeResultToKotlin(getVirtualNodePlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Virtual Router data source allows details of an App Mesh Virtual Service to be retrieved by its name and mesh_name.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualRouterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualRouter(GetVirtualRouterArgs.builder()
     *             .meshName("example-mesh-name")
     *             .name("example-router-name")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVirtualRouter.
     * @return A collection of values returned by getVirtualRouter.
     */
    public suspend fun getVirtualRouter(argument: GetVirtualRouterPlainArgs): GetVirtualRouterResult =
        getVirtualRouterResultToKotlin(getVirtualRouterPlain(argument.toJava()).await())

    /**
     * @see [getVirtualRouter].
     * @param meshName Name of the mesh in which the virtual router exists
     * @param meshOwner
     * @param name Name of the virtual router.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualRouter.
     */
    public suspend fun getVirtualRouter(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualRouterResult {
        val argument = GetVirtualRouterPlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getVirtualRouterResultToKotlin(getVirtualRouterPlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualRouter].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualRouterPlainArgs].
     * @return A collection of values returned by getVirtualRouter.
     */
    public suspend
    fun getVirtualRouter(argument: suspend GetVirtualRouterPlainArgsBuilder.() -> Unit):
        GetVirtualRouterResult {
        val builder = GetVirtualRouterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualRouterResultToKotlin(getVirtualRouterPlain(builtArgument.toJava()).await())
    }

    /**
     * The App Mesh Virtual Service data source allows details of an App Mesh Virtual Service to be retrieved by its name, mesh_name, and optionally the mesh_owner.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appmesh.AppmeshFunctions;
     * import com.pulumi.aws.appmesh.inputs.GetVirtualServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = AppmeshFunctions.getVirtualService(GetVirtualServiceArgs.builder()
     *             .meshName("example-mesh")
     *             .name("example.mesh.local")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVirtualService.
     * @return A collection of values returned by getVirtualService.
     */
    public suspend fun getVirtualService(argument: GetVirtualServicePlainArgs):
        GetVirtualServiceResult =
        getVirtualServiceResultToKotlin(getVirtualServicePlain(argument.toJava()).await())

    /**
     * @see [getVirtualService].
     * @param meshName Name of the service mesh in which the virtual service exists.
     * @param meshOwner AWS account ID of the service mesh's owner.
     * @param name Name of the virtual service.
     * @param tags Map of tags.
     * @return A collection of values returned by getVirtualService.
     */
    public suspend fun getVirtualService(
        meshName: String,
        meshOwner: String? = null,
        name: String,
        tags: Map<String, String>? = null,
    ): GetVirtualServiceResult {
        val argument = GetVirtualServicePlainArgs(
            meshName = meshName,
            meshOwner = meshOwner,
            name = name,
            tags = tags,
        )
        return getVirtualServiceResultToKotlin(getVirtualServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appmesh&#46;kotlin&#46;inputs&#46;GetVirtualServicePlainArgs].
     * @return A collection of values returned by getVirtualService.
     */
    public suspend
    fun getVirtualService(argument: suspend GetVirtualServicePlainArgsBuilder.() -> Unit):
        GetVirtualServiceResult {
        val builder = GetVirtualServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualServiceResultToKotlin(getVirtualServicePlain(builtArgument.toJava()).await())
    }
}
