@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.GatewayRouteArgs.builder
import com.pulumi.aws.appmesh.kotlin.inputs.GatewayRouteSpecArgs
import com.pulumi.aws.appmesh.kotlin.inputs.GatewayRouteSpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS App Mesh gateway route resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.GatewayRoute;
 * import com.pulumi.aws.appmesh.GatewayRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs;
 * import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GatewayRoute("example", GatewayRouteArgs.builder()
 *             .meshName("example-service-mesh")
 *             .virtualGatewayName(aws_appmesh_virtual_gateway.example().name())
 *             .spec(GatewayRouteSpecArgs.builder()
 *                 .httpRoute(GatewayRouteSpecHttpRouteArgs.builder()
 *                     .action(GatewayRouteSpecHttpRouteActionArgs.builder()
 *                         .target(GatewayRouteSpecHttpRouteActionTargetArgs.builder()
 *                             .virtualService(GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs.builder()
 *                                 .virtualServiceName(aws_appmesh_virtual_service.example().name())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .match(GatewayRouteSpecHttpRouteMatchArgs.builder()
 *                         .prefix("/")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Mesh gateway routes using `mesh_name` and `virtual_gateway_name` together with the gateway route's `name`. For example:
 * ```sh
 *  $ pulumi import aws:appmesh/gatewayRoute:GatewayRoute example mesh/gw1/example-gateway-route
 * ```
 * @property meshName Name of the service mesh in which to create the gateway route. Must be between 1 and 255 characters in length.
 * @property meshOwner AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
 * @property name Name to use for the gateway route. Must be between 1 and 255 characters in length.
 * @property spec Gateway route specification to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property virtualGatewayName Name of the virtual gateway to associate the gateway route with. Must be between 1 and 255 characters in length.
 */
public data class GatewayRouteArgs(
    public val meshName: Output<String>? = null,
    public val meshOwner: Output<String>? = null,
    public val name: Output<String>? = null,
    public val spec: Output<GatewayRouteSpecArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualGatewayName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.GatewayRouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.GatewayRouteArgs =
        com.pulumi.aws.appmesh.GatewayRouteArgs.builder()
            .meshName(meshName?.applyValue({ args0 -> args0 }))
            .meshOwner(meshOwner?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualGatewayName(virtualGatewayName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteArgs].
 */
@PulumiTagMarker
public class GatewayRouteArgsBuilder internal constructor() {
    private var meshName: Output<String>? = null

    private var meshOwner: Output<String>? = null

    private var name: Output<String>? = null

    private var spec: Output<GatewayRouteSpecArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualGatewayName: Output<String>? = null

    /**
     * @param value Name of the service mesh in which to create the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("xeagsqxoqqqrsmgq")
    public suspend fun meshName(`value`: Output<String>) {
        this.meshName = value
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("eghjsqrphvlhwycr")
    public suspend fun meshOwner(`value`: Output<String>) {
        this.meshOwner = value
    }

    /**
     * @param value Name to use for the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("nfhollkpbgvtejay")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gateway route specification to apply.
     */
    @JvmName("yjyfvnhsvfwboari")
    public suspend fun spec(`value`: Output<GatewayRouteSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wapoqosdykgyoajv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the virtual gateway to associate the gateway route with. Must be between 1 and 255 characters in length.
     */
    @JvmName("kesdpfarnvoqgssu")
    public suspend fun virtualGatewayName(`value`: Output<String>) {
        this.virtualGatewayName = value
    }

    /**
     * @param value Name of the service mesh in which to create the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("adejjtrvumalesnl")
    public suspend fun meshName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("mstuvlrxyqlpdlnn")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshOwner = mapped
    }

    /**
     * @param value Name to use for the gateway route. Must be between 1 and 255 characters in length.
     */
    @JvmName("bxrhabadyuljtspb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gateway route specification to apply.
     */
    @JvmName("vxxpvbaufikowgfp")
    public suspend fun spec(`value`: GatewayRouteSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument Gateway route specification to apply.
     */
    @JvmName("mjvsfbcavcbdcfqd")
    public suspend fun spec(argument: suspend GatewayRouteSpecArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rpwfhtmfwnairexa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vjfbnekxcwpduwdi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the virtual gateway to associate the gateway route with. Must be between 1 and 255 characters in length.
     */
    @JvmName("uttmnipaghcynaod")
    public suspend fun virtualGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualGatewayName = mapped
    }

    internal fun build(): GatewayRouteArgs = GatewayRouteArgs(
        meshName = meshName,
        meshOwner = meshOwner,
        name = name,
        spec = spec,
        tags = tags,
        virtualGatewayName = virtualGatewayName,
    )
}
