@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.kotlin.outputs.RouteSpec
import com.pulumi.aws.appmesh.kotlin.outputs.RouteSpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Route].
 */
@PulumiTagMarker
public class RouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteArgs = RouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteArgsBuilder.() -> Unit) {
        val builder = RouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Route {
        val builtJavaResource = com.pulumi.aws.appmesh.Route(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Route(builtJavaResource)
    }
}

/**
 * Provides an AWS App Mesh route resource.
 * ## Example Usage
 * ### HTTP Routing
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Route;
 * import com.pulumi.aws.appmesh.RouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb = new Route("serviceb", RouteArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .virtualRouterName(aws_appmesh_virtual_router.serviceb().name())
 *             .spec(RouteSpecArgs.builder()
 *                 .httpRoute(RouteSpecHttpRouteArgs.builder()
 *                     .match(RouteSpecHttpRouteMatchArgs.builder()
 *                         .prefix("/")
 *                         .build())
 *                     .action(RouteSpecHttpRouteActionArgs.builder()
 *                         .weightedTargets(
 *                             RouteSpecHttpRouteActionWeightedTargetArgs.builder()
 *                                 .virtualNode(aws_appmesh_virtual_node.serviceb1().name())
 *                                 .weight(90)
 *                                 .build(),
 *                             RouteSpecHttpRouteActionWeightedTargetArgs.builder()
 *                                 .virtualNode(aws_appmesh_virtual_node.serviceb2().name())
 *                                 .weight(10)
 *                                 .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### HTTP Header Routing
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Route;
 * import com.pulumi.aws.appmesh.RouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb = new Route("serviceb", RouteArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .virtualRouterName(aws_appmesh_virtual_router.serviceb().name())
 *             .spec(RouteSpecArgs.builder()
 *                 .httpRoute(RouteSpecHttpRouteArgs.builder()
 *                     .match(RouteSpecHttpRouteMatchArgs.builder()
 *                         .method("POST")
 *                         .prefix("/")
 *                         .scheme("https")
 *                         .headers(RouteSpecHttpRouteMatchHeaderArgs.builder()
 *                             .name("clientRequestId")
 *                             .match(RouteSpecHttpRouteMatchHeaderMatchArgs.builder()
 *                                 .prefix("123")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .action(RouteSpecHttpRouteActionArgs.builder()
 *                         .weightedTargets(RouteSpecHttpRouteActionWeightedTargetArgs.builder()
 *                             .virtualNode(aws_appmesh_virtual_node.serviceb().name())
 *                             .weight(100)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Retry Policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Route;
 * import com.pulumi.aws.appmesh.RouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb = new Route("serviceb", RouteArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .virtualRouterName(aws_appmesh_virtual_router.serviceb().name())
 *             .spec(RouteSpecArgs.builder()
 *                 .httpRoute(RouteSpecHttpRouteArgs.builder()
 *                     .match(RouteSpecHttpRouteMatchArgs.builder()
 *                         .prefix("/")
 *                         .build())
 *                     .retryPolicy(RouteSpecHttpRouteRetryPolicyArgs.builder()
 *                         .httpRetryEvents("server-error")
 *                         .maxRetries(1)
 *                         .perRetryTimeout(RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs.builder()
 *                             .unit("s")
 *                             .value(15)
 *                             .build())
 *                         .build())
 *                     .action(RouteSpecHttpRouteActionArgs.builder()
 *                         .weightedTargets(RouteSpecHttpRouteActionWeightedTargetArgs.builder()
 *                             .virtualNode(aws_appmesh_virtual_node.serviceb().name())
 *                             .weight(100)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### TCP Routing
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.Route;
 * import com.pulumi.aws.appmesh.RouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteArgs;
 * import com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb = new Route("serviceb", RouteArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .virtualRouterName(aws_appmesh_virtual_router.serviceb().name())
 *             .spec(RouteSpecArgs.builder()
 *                 .tcpRoute(RouteSpecTcpRouteArgs.builder()
 *                     .action(RouteSpecTcpRouteActionArgs.builder()
 *                         .weightedTargets(RouteSpecTcpRouteActionWeightedTargetArgs.builder()
 *                             .virtualNode(aws_appmesh_virtual_node.serviceb1().name())
 *                             .weight(100)
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Mesh virtual routes using `mesh_name` and `virtual_router_name` together with the route's `name`. For example:
 * ```sh
 *  $ pulumi import aws:appmesh/route:Route serviceb simpleapp/serviceB/serviceB-route
 * ```
 *
 */
public class Route internal constructor(
    override val javaResource: com.pulumi.aws.appmesh.Route,
) : KotlinCustomResource(javaResource, RouteMapper) {
    /**
     * ARN of the route.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the route.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Last update date of the route.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Name of the service mesh in which to create the route. Must be between 1 and 255 characters in length.
     */
    public val meshName: Output<String>
        get() = javaResource.meshName().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    public val meshOwner: Output<String>
        get() = javaResource.meshOwner().applyValue({ args0 -> args0 })

    /**
     * Name to use for the route. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource owner's AWS account ID.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * Route specification to apply.
     */
    public val spec: Output<RouteSpec>
        get() = javaResource.spec().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Name of the virtual router in which to create the route. Must be between 1 and 255 characters in length.
     */
    public val virtualRouterName: Output<String>
        get() = javaResource.virtualRouterName().applyValue({ args0 -> args0 })
}

public object RouteMapper : ResourceMapper<Route> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appmesh.Route::class == javaResource::class

    override fun map(javaResource: Resource): Route = Route(
        javaResource as
            com.pulumi.aws.appmesh.Route,
    )
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Route].
 */
public suspend fun route(name: String, block: suspend RouteResourceBuilder.() -> Unit): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 */
public fun route(name: String): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
