@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.VirtualGatewayArgs.builder
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualGatewaySpecArgs
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualGatewaySpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS App Mesh virtual gateway resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualGateway;
 * import com.pulumi.aws.appmesh.VirtualGatewayArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualGateway("example", VirtualGatewayArgs.builder()
 *             .meshName("example-service-mesh")
 *             .spec(VirtualGatewaySpecArgs.builder()
 *                 .listeners(VirtualGatewaySpecListenerArgs.builder()
 *                     .portMapping(VirtualGatewaySpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ### Access Logs and TLS
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualGateway;
 * import com.pulumi.aws.appmesh.VirtualGatewayArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualGatewaySpecLoggingAccessLogFileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualGateway("example", VirtualGatewayArgs.builder()
 *             .meshName("example-service-mesh")
 *             .spec(VirtualGatewaySpecArgs.builder()
 *                 .listeners(VirtualGatewaySpecListenerArgs.builder()
 *                     .portMapping(VirtualGatewaySpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .tls(VirtualGatewaySpecListenerTlsArgs.builder()
 *                         .certificate(VirtualGatewaySpecListenerTlsCertificateArgs.builder()
 *                             .acm(VirtualGatewaySpecListenerTlsCertificateAcmArgs.builder()
 *                                 .certificateArn(aws_acm_certificate.example().arn())
 *                                 .build())
 *                             .build())
 *                         .mode("STRICT")
 *                         .build())
 *                     .build())
 *                 .logging(VirtualGatewaySpecLoggingArgs.builder()
 *                     .accessLog(VirtualGatewaySpecLoggingAccessLogArgs.builder()
 *                         .file(VirtualGatewaySpecLoggingAccessLogFileArgs.builder()
 *                             .path("/var/log/access.log")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Mesh virtual gateway using `mesh_name` together with the virtual gateway's `name`. For example:
 * ```sh
 *  $ pulumi import aws:appmesh/virtualGateway:VirtualGateway example mesh/gw1
 * ```
 * @property meshName Name of the service mesh in which to create the virtual gateway. Must be between 1 and 255 characters in length.
 * @property meshOwner AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
 * @property name Name to use for the virtual gateway. Must be between 1 and 255 characters in length.
 * @property spec Virtual gateway specification to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VirtualGatewayArgs(
    public val meshName: Output<String>? = null,
    public val meshOwner: Output<String>? = null,
    public val name: Output<String>? = null,
    public val spec: Output<VirtualGatewaySpecArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.VirtualGatewayArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.VirtualGatewayArgs =
        com.pulumi.aws.appmesh.VirtualGatewayArgs.builder()
            .meshName(meshName?.applyValue({ args0 -> args0 }))
            .meshOwner(meshOwner?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VirtualGatewayArgs].
 */
@PulumiTagMarker
public class VirtualGatewayArgsBuilder internal constructor() {
    private var meshName: Output<String>? = null

    private var meshOwner: Output<String>? = null

    private var name: Output<String>? = null

    private var spec: Output<VirtualGatewaySpecArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the service mesh in which to create the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("myuoqchogjhsohgl")
    public suspend fun meshName(`value`: Output<String>) {
        this.meshName = value
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("lxugermmkrwwpcvb")
    public suspend fun meshOwner(`value`: Output<String>) {
        this.meshOwner = value
    }

    /**
     * @param value Name to use for the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("blpcpvsykyjncouu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Virtual gateway specification to apply.
     */
    @JvmName("ivlpscqfxcgovvwq")
    public suspend fun spec(`value`: Output<VirtualGatewaySpecArgs>) {
        this.spec = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hvrmqxdxwnnfnkpk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the service mesh in which to create the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("luyhefwdvhcxnvmw")
    public suspend fun meshName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("xktcksbloobqryey")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshOwner = mapped
    }

    /**
     * @param value Name to use for the virtual gateway. Must be between 1 and 255 characters in length.
     */
    @JvmName("tbcrxgxotdmbtbgq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Virtual gateway specification to apply.
     */
    @JvmName("enqvfviglfowjdxb")
    public suspend fun spec(`value`: VirtualGatewaySpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument Virtual gateway specification to apply.
     */
    @JvmName("velegqqqlqupsnwk")
    public suspend fun spec(argument: suspend VirtualGatewaySpecArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualGatewaySpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("huwqlarcigxgkdxy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kfhjxtiqcrinhxev")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VirtualGatewayArgs = VirtualGatewayArgs(
        meshName = meshName,
        meshOwner = meshOwner,
        name = name,
        spec = spec,
        tags = tags,
    )
}
