@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpec
import com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VirtualNode].
 */
@PulumiTagMarker
public class VirtualNodeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNodeArgs = VirtualNodeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNodeArgsBuilder.() -> Unit) {
        val builder = VirtualNodeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualNode {
        val builtJavaResource = com.pulumi.aws.appmesh.VirtualNode(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualNode(builtJavaResource)
    }
}

/**
 * Provides an AWS App Mesh virtual node resource.
 * ## Breaking Changes
 * Because of backward incompatible API changes (read [here](https://github.com/awslabs/aws-app-mesh-examples/issues/92)), `aws.appmesh.VirtualNode` resource definitions created with provider versions earlier than v2.3.0 will need to be modified:
 * * Rename the `service_name` attribute of the `dns` object to `hostname`.
 * * Replace the `backends` attribute of the `spec` object with one or more `backend` configuration blocks,
 * setting `virtual_service_name` to the name of the service.
 * The state associated with existing resources will automatically be migrated.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualNode;
 * import com.pulumi.aws.appmesh.VirtualNodeArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryDnsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb1 = new VirtualNode("serviceb1", VirtualNodeArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .spec(VirtualNodeSpecArgs.builder()
 *                 .backends(VirtualNodeSpecBackendArgs.builder()
 *                     .virtualService(VirtualNodeSpecBackendVirtualServiceArgs.builder()
 *                         .virtualServiceName("servicea.simpleapp.local")
 *                         .build())
 *                     .build())
 *                 .listeners(VirtualNodeSpecListenerArgs.builder()
 *                     .portMapping(VirtualNodeSpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .serviceDiscovery(VirtualNodeSpecServiceDiscoveryArgs.builder()
 *                     .dns(VirtualNodeSpecServiceDiscoveryDnsArgs.builder()
 *                         .hostname("serviceb.simpleapp.local")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Cloud Map Service Discovery
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicediscovery.HttpNamespace;
 * import com.pulumi.aws.appmesh.VirtualNode;
 * import com.pulumi.aws.appmesh.VirtualNodeArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HttpNamespace("example");
 *         var serviceb1 = new VirtualNode("serviceb1", VirtualNodeArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .spec(VirtualNodeSpecArgs.builder()
 *                 .backends(VirtualNodeSpecBackendArgs.builder()
 *                     .virtualService(VirtualNodeSpecBackendVirtualServiceArgs.builder()
 *                         .virtualServiceName("servicea.simpleapp.local")
 *                         .build())
 *                     .build())
 *                 .listeners(VirtualNodeSpecListenerArgs.builder()
 *                     .portMapping(VirtualNodeSpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .serviceDiscovery(VirtualNodeSpecServiceDiscoveryArgs.builder()
 *                     .awsCloudMap(VirtualNodeSpecServiceDiscoveryAwsCloudMapArgs.builder()
 *                         .attributes(Map.of("stack", "blue"))
 *                         .serviceName("serviceb1")
 *                         .namespaceName(example.name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Listener Health Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualNode;
 * import com.pulumi.aws.appmesh.VirtualNodeArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryDnsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb1 = new VirtualNode("serviceb1", VirtualNodeArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .spec(VirtualNodeSpecArgs.builder()
 *                 .backends(VirtualNodeSpecBackendArgs.builder()
 *                     .virtualService(VirtualNodeSpecBackendVirtualServiceArgs.builder()
 *                         .virtualServiceName("servicea.simpleapp.local")
 *                         .build())
 *                     .build())
 *                 .listeners(VirtualNodeSpecListenerArgs.builder()
 *                     .portMapping(VirtualNodeSpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .healthCheck(VirtualNodeSpecListenerHealthCheckArgs.builder()
 *                         .protocol("http")
 *                         .path("/ping")
 *                         .healthyThreshold(2)
 *                         .unhealthyThreshold(2)
 *                         .timeoutMillis(2000)
 *                         .intervalMillis(5000)
 *                         .build())
 *                     .build())
 *                 .serviceDiscovery(VirtualNodeSpecServiceDiscoveryArgs.builder()
 *                     .dns(VirtualNodeSpecServiceDiscoveryDnsArgs.builder()
 *                         .hostname("serviceb.simpleapp.local")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualNode;
 * import com.pulumi.aws.appmesh.VirtualNodeArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecServiceDiscoveryDnsArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualNodeSpecLoggingAccessLogFileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb1 = new VirtualNode("serviceb1", VirtualNodeArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .spec(VirtualNodeSpecArgs.builder()
 *                 .backends(VirtualNodeSpecBackendArgs.builder()
 *                     .virtualService(VirtualNodeSpecBackendVirtualServiceArgs.builder()
 *                         .virtualServiceName("servicea.simpleapp.local")
 *                         .build())
 *                     .build())
 *                 .listeners(VirtualNodeSpecListenerArgs.builder()
 *                     .portMapping(VirtualNodeSpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .serviceDiscovery(VirtualNodeSpecServiceDiscoveryArgs.builder()
 *                     .dns(VirtualNodeSpecServiceDiscoveryDnsArgs.builder()
 *                         .hostname("serviceb.simpleapp.local")
 *                         .build())
 *                     .build())
 *                 .logging(VirtualNodeSpecLoggingArgs.builder()
 *                     .accessLog(VirtualNodeSpecLoggingAccessLogArgs.builder()
 *                         .file(VirtualNodeSpecLoggingAccessLogFileArgs.builder()
 *                             .path("/dev/stdout")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Mesh virtual nodes using `mesh_name` together with the virtual node's `name`. For example:
 * ```sh
 *  $ pulumi import aws:appmesh/virtualNode:VirtualNode serviceb1 simpleapp/serviceBv1
 * ```
 *
 */
public class VirtualNode internal constructor(
    override val javaResource: com.pulumi.aws.appmesh.VirtualNode,
) : KotlinCustomResource(javaResource, VirtualNodeMapper) {
    /**
     * ARN of the virtual node.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the virtual node.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Last update date of the virtual node.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Name of the service mesh in which to create the virtual node. Must be between 1 and 255 characters in length.
     */
    public val meshName: Output<String>
        get() = javaResource.meshName().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    public val meshOwner: Output<String>
        get() = javaResource.meshOwner().applyValue({ args0 -> args0 })

    /**
     * Name to use for the virtual node. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource owner's AWS account ID.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * Virtual node specification to apply.
     */
    public val spec: Output<VirtualNodeSpec>
        get() = javaResource.spec().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VirtualNodeMapper : ResourceMapper<VirtualNode> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appmesh.VirtualNode::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNode = VirtualNode(
        javaResource as
            com.pulumi.aws.appmesh.VirtualNode,
    )
}

/**
 * @see [VirtualNode].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNode].
 */
public suspend fun virtualNode(name: String, block: suspend VirtualNodeResourceBuilder.() -> Unit):
    VirtualNode {
    val builder = VirtualNodeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNode].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNode(name: String): VirtualNode {
    val builder = VirtualNodeResourceBuilder()
    builder.name(name)
    return builder.build()
}
