@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.kotlin.outputs.VirtualRouterSpec
import com.pulumi.aws.appmesh.kotlin.outputs.VirtualRouterSpec.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VirtualRouter].
 */
@PulumiTagMarker
public class VirtualRouterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualRouterArgs = VirtualRouterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualRouterArgsBuilder.() -> Unit) {
        val builder = VirtualRouterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualRouter {
        val builtJavaResource = com.pulumi.aws.appmesh.VirtualRouter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualRouter(builtJavaResource)
    }
}

/**
 * Provides an AWS App Mesh virtual router resource.
 * ## Breaking Changes
 * Because of backward incompatible API changes (read [here](https://github&#46;com/awslabs/aws-app-mesh-examples/issues/92) and [here](https://github.com/awslabs/aws-app-mesh-examples/issues/94)), `aws.appmesh.VirtualRouter` resource definitions created with provider versions earlier than v2.3.0 will need to be modified:
 * * Remove service `service_names` from the `spec` argument. AWS has created a `aws.appmesh.VirtualService` resource for each service name. Import these resource using `pulumi import`.
 * * Add a `listener` configuration block to the `spec` argument.
 * The state associated with existing resources will automatically be migrated.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualRouter;
 * import com.pulumi.aws.appmesh.VirtualRouterArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualRouterSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceb = new VirtualRouter("serviceb", VirtualRouterArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .spec(VirtualRouterSpecArgs.builder()
 *                 .listeners(VirtualRouterSpecListenerArgs.builder()
 *                     .portMapping(VirtualRouterSpecListenerPortMappingArgs.builder()
 *                         .port(8080)
 *                         .protocol("http")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Mesh virtual routers using `mesh_name` together with the virtual router's `name`. For example:
 * ```sh
 *  $ pulumi import aws:appmesh/virtualRouter:VirtualRouter serviceb simpleapp/serviceB
 * ```
 *
 */
public class VirtualRouter internal constructor(
    override val javaResource: com.pulumi.aws.appmesh.VirtualRouter,
) : KotlinCustomResource(javaResource, VirtualRouterMapper) {
    /**
     * ARN of the virtual router.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the virtual router.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Last update date of the virtual router.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Name of the service mesh in which to create the virtual router. Must be between 1 and 255 characters in length.
     */
    public val meshName: Output<String>
        get() = javaResource.meshName().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    public val meshOwner: Output<String>
        get() = javaResource.meshOwner().applyValue({ args0 -> args0 })

    /**
     * Name to use for the virtual router. Must be between 1 and 255 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource owner's AWS account ID.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * Virtual router specification to apply.
     */
    public val spec: Output<VirtualRouterSpec>
        get() = javaResource.spec().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VirtualRouterMapper : ResourceMapper<VirtualRouter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appmesh.VirtualRouter::class == javaResource::class

    override fun map(javaResource: Resource): VirtualRouter = VirtualRouter(
        javaResource as
            com.pulumi.aws.appmesh.VirtualRouter,
    )
}

/**
 * @see [VirtualRouter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualRouter].
 */
public suspend fun virtualRouter(
    name: String,
    block: suspend VirtualRouterResourceBuilder.() -> Unit,
): VirtualRouter {
    val builder = VirtualRouterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualRouter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualRouter(name: String): VirtualRouter {
    val builder = VirtualRouterResourceBuilder()
    builder.name(name)
    return builder.build()
}
