@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin

import com.pulumi.aws.appmesh.VirtualServiceArgs.builder
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualServiceSpecArgs
import com.pulumi.aws.appmesh.kotlin.inputs.VirtualServiceSpecArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS App Mesh virtual service resource.
 * ## Example Usage
 * ### Virtual Node Provider
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualService;
 * import com.pulumi.aws.appmesh.VirtualServiceArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var servicea = new VirtualService("servicea", VirtualServiceArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .spec(VirtualServiceSpecArgs.builder()
 *                 .provider(VirtualServiceSpecProviderArgs.builder()
 *                     .virtualNode(VirtualServiceSpecProviderVirtualNodeArgs.builder()
 *                         .virtualNodeName(aws_appmesh_virtual_node.serviceb1().name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Virtual Router Provider
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appmesh.VirtualService;
 * import com.pulumi.aws.appmesh.VirtualServiceArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderArgs;
 * import com.pulumi.aws.appmesh.inputs.VirtualServiceSpecProviderVirtualRouterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var servicea = new VirtualService("servicea", VirtualServiceArgs.builder()
 *             .meshName(aws_appmesh_mesh.simple().id())
 *             .spec(VirtualServiceSpecArgs.builder()
 *                 .provider(VirtualServiceSpecProviderArgs.builder()
 *                     .virtualRouter(VirtualServiceSpecProviderVirtualRouterArgs.builder()
 *                         .virtualRouterName(aws_appmesh_virtual_router.serviceb().name())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import App Mesh virtual services using `mesh_name` together with the virtual service's `name`. For example:
 * ```sh
 *  $ pulumi import aws:appmesh/virtualService:VirtualService servicea simpleapp/servicea.simpleapp.local
 * ```
 * @property meshName Name of the service mesh in which to create the virtual service. Must be between 1 and 255 characters in length.
 * @property meshOwner AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
 * @property name Name to use for the virtual service. Must be between 1 and 255 characters in length.
 * @property spec Virtual service specification to apply.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VirtualServiceArgs(
    public val meshName: Output<String>? = null,
    public val meshOwner: Output<String>? = null,
    public val name: Output<String>? = null,
    public val spec: Output<VirtualServiceSpecArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.VirtualServiceArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.VirtualServiceArgs =
        com.pulumi.aws.appmesh.VirtualServiceArgs.builder()
            .meshName(meshName?.applyValue({ args0 -> args0 }))
            .meshOwner(meshOwner?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VirtualServiceArgs].
 */
@PulumiTagMarker
public class VirtualServiceArgsBuilder internal constructor() {
    private var meshName: Output<String>? = null

    private var meshOwner: Output<String>? = null

    private var name: Output<String>? = null

    private var spec: Output<VirtualServiceSpecArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the service mesh in which to create the virtual service. Must be between 1 and 255 characters in length.
     */
    @JvmName("lxfgtaxkkbxwtnvu")
    public suspend fun meshName(`value`: Output<String>) {
        this.meshName = value
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("pnndlpgnalrdhyen")
    public suspend fun meshOwner(`value`: Output<String>) {
        this.meshOwner = value
    }

    /**
     * @param value Name to use for the virtual service. Must be between 1 and 255 characters in length.
     */
    @JvmName("rxhscxbenjofhqht")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Virtual service specification to apply.
     */
    @JvmName("gorykrguomyticba")
    public suspend fun spec(`value`: Output<VirtualServiceSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("erooyponvcgsjnwp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the service mesh in which to create the virtual service. Must be between 1 and 255 characters in length.
     */
    @JvmName("mpulcnjlrrardpxv")
    public suspend fun meshName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("kbboxvvnlrrlhyhr")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meshOwner = mapped
    }

    /**
     * @param value Name to use for the virtual service. Must be between 1 and 255 characters in length.
     */
    @JvmName("anlilydaslcyrdxe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Virtual service specification to apply.
     */
    @JvmName("bnmcwwrawrdpuejs")
    public suspend fun spec(`value`: VirtualServiceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument Virtual service specification to apply.
     */
    @JvmName("ociswhdomijekuni")
    public suspend fun spec(argument: suspend VirtualServiceSpecArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualServiceSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtitscogyarustmo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fwwafkvwqbhhkfmt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VirtualServiceArgs = VirtualServiceArgs(
        meshName = meshName,
        meshOwner = meshOwner,
        name = name,
        spec = spec,
        tags = tags,
    )
}
