@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property grpcRoute Specification of a gRPC gateway route.
 * @property http2Route Specification of an HTTP/2 gateway route.
 * @property httpRoute Specification of an HTTP gateway route.
 * @property priority Priority for the gateway route, between `0` and `1000`.
 */
public data class GatewayRouteSpecArgs(
    public val grpcRoute: Output<GatewayRouteSpecGrpcRouteArgs>? = null,
    public val http2Route: Output<GatewayRouteSpecHttp2RouteArgs>? = null,
    public val httpRoute: Output<GatewayRouteSpecHttpRouteArgs>? = null,
    public val priority: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecArgs.builder()
            .grpcRoute(grpcRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .http2Route(http2Route?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpRoute(httpRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecArgsBuilder internal constructor() {
    private var grpcRoute: Output<GatewayRouteSpecGrpcRouteArgs>? = null

    private var http2Route: Output<GatewayRouteSpecHttp2RouteArgs>? = null

    private var httpRoute: Output<GatewayRouteSpecHttpRouteArgs>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Specification of a gRPC gateway route.
     */
    @JvmName("lcejylsxpumwpucg")
    public suspend fun grpcRoute(`value`: Output<GatewayRouteSpecGrpcRouteArgs>) {
        this.grpcRoute = value
    }

    /**
     * @param value Specification of an HTTP/2 gateway route.
     */
    @JvmName("dfqgwgfbccaxibop")
    public suspend fun http2Route(`value`: Output<GatewayRouteSpecHttp2RouteArgs>) {
        this.http2Route = value
    }

    /**
     * @param value Specification of an HTTP gateway route.
     */
    @JvmName("annojpuastlrhxcg")
    public suspend fun httpRoute(`value`: Output<GatewayRouteSpecHttpRouteArgs>) {
        this.httpRoute = value
    }

    /**
     * @param value Priority for the gateway route, between `0` and `1000`.
     */
    @JvmName("ejrxbqjaynwixqtd")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Specification of a gRPC gateway route.
     */
    @JvmName("fpsuuwrshfxybebg")
    public suspend fun grpcRoute(`value`: GatewayRouteSpecGrpcRouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grpcRoute = mapped
    }

    /**
     * @param argument Specification of a gRPC gateway route.
     */
    @JvmName("raouovtbhuerabts")
    public suspend fun grpcRoute(argument: suspend GatewayRouteSpecGrpcRouteArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecGrpcRouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.grpcRoute = mapped
    }

    /**
     * @param value Specification of an HTTP/2 gateway route.
     */
    @JvmName("yjhpxqldxxrschoa")
    public suspend fun http2Route(`value`: GatewayRouteSpecHttp2RouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2Route = mapped
    }

    /**
     * @param argument Specification of an HTTP/2 gateway route.
     */
    @JvmName("ehnskqkqqaeueeht")
    public suspend
    fun http2Route(argument: suspend GatewayRouteSpecHttp2RouteArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.http2Route = mapped
    }

    /**
     * @param value Specification of an HTTP gateway route.
     */
    @JvmName("gmuespgxmbiyibep")
    public suspend fun httpRoute(`value`: GatewayRouteSpecHttpRouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRoute = mapped
    }

    /**
     * @param argument Specification of an HTTP gateway route.
     */
    @JvmName("gabtvmmgxbhalyek")
    public suspend fun httpRoute(argument: suspend GatewayRouteSpecHttpRouteArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpRoute = mapped
    }

    /**
     * @param value Priority for the gateway route, between `0` and `1000`.
     */
    @JvmName("rdkxijyfhxsofpdr")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): GatewayRouteSpecArgs = GatewayRouteSpecArgs(
        grpcRoute = grpcRoute,
        http2Route = http2Route,
        httpRoute = httpRoute,
        priority = priority,
    )
}
