@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property target Target that traffic is routed to when a request matches the gateway route.
 */
public data class GatewayRouteSpecGrpcRouteActionArgs(
    public val target: Output<GatewayRouteSpecGrpcRouteActionTargetArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteActionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteActionArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteActionArgs.builder()
            .target(target.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayRouteSpecGrpcRouteActionArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecGrpcRouteActionArgsBuilder internal constructor() {
    private var target: Output<GatewayRouteSpecGrpcRouteActionTargetArgs>? = null

    /**
     * @param value Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("uardjabylcihogdi")
    public suspend fun target(`value`: Output<GatewayRouteSpecGrpcRouteActionTargetArgs>) {
        this.target = value
    }

    /**
     * @param value Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("hmkmysahkivkjrrf")
    public suspend fun target(`value`: GatewayRouteSpecGrpcRouteActionTargetArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("xdmeqlujqothlegm")
    public suspend
    fun target(argument: suspend GatewayRouteSpecGrpcRouteActionTargetArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecGrpcRouteActionTargetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): GatewayRouteSpecGrpcRouteActionArgs = GatewayRouteSpecGrpcRouteActionArgs(
        target = target ?: throw PulumiNullFieldException("target"),
    )
}
