@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining a request match.
 */
public data class GatewayRouteSpecGrpcRouteArgs(
    public val action: Output<GatewayRouteSpecGrpcRouteActionArgs>,
    public val match: Output<GatewayRouteSpecGrpcRouteMatchArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecGrpcRouteArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayRouteSpecGrpcRouteArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecGrpcRouteArgsBuilder internal constructor() {
    private var action: Output<GatewayRouteSpecGrpcRouteActionArgs>? = null

    private var match: Output<GatewayRouteSpecGrpcRouteMatchArgs>? = null

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("fckkvnkjmcvxlsxo")
    public suspend fun action(`value`: Output<GatewayRouteSpecGrpcRouteActionArgs>) {
        this.action = value
    }

    /**
     * @param value Criteria for determining a request match.
     */
    @JvmName("bavnbukomkihjjyp")
    public suspend fun match(`value`: Output<GatewayRouteSpecGrpcRouteMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("evakcucqcqahqvlh")
    public suspend fun action(`value`: GatewayRouteSpecGrpcRouteActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Action to take if a match is determined.
     */
    @JvmName("hrabgqcudwnvmarp")
    public suspend
    fun action(argument: suspend GatewayRouteSpecGrpcRouteActionArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecGrpcRouteActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Criteria for determining a request match.
     */
    @JvmName("gvyyubabnvovwxir")
    public suspend fun match(`value`: GatewayRouteSpecGrpcRouteMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining a request match.
     */
    @JvmName("jvcotwrbsakhnrsd")
    public suspend fun match(argument: suspend GatewayRouteSpecGrpcRouteMatchArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecGrpcRouteMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    internal fun build(): GatewayRouteSpecGrpcRouteArgs = GatewayRouteSpecGrpcRouteArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        match = match ?: throw PulumiNullFieldException("match"),
    )
}
