@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property rewrite Gateway route action to rewrite.
 * @property target Target that traffic is routed to when a request matches the gateway route.
 */
public data class GatewayRouteSpecHttp2RouteActionArgs(
    public val rewrite: Output<GatewayRouteSpecHttp2RouteActionRewriteArgs>? = null,
    public val target: Output<GatewayRouteSpecHttp2RouteActionTargetArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionArgs.builder()
            .rewrite(rewrite?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteActionArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteActionArgsBuilder internal constructor() {
    private var rewrite: Output<GatewayRouteSpecHttp2RouteActionRewriteArgs>? = null

    private var target: Output<GatewayRouteSpecHttp2RouteActionTargetArgs>? = null

    /**
     * @param value Gateway route action to rewrite.
     */
    @JvmName("bfuxyuakeglqdkyk")
    public suspend fun rewrite(`value`: Output<GatewayRouteSpecHttp2RouteActionRewriteArgs>) {
        this.rewrite = value
    }

    /**
     * @param value Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("soxeipvrlsbrkcut")
    public suspend fun target(`value`: Output<GatewayRouteSpecHttp2RouteActionTargetArgs>) {
        this.target = value
    }

    /**
     * @param value Gateway route action to rewrite.
     */
    @JvmName("fgqcoilvhkrqidir")
    public suspend fun rewrite(`value`: GatewayRouteSpecHttp2RouteActionRewriteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewrite = mapped
    }

    /**
     * @param argument Gateway route action to rewrite.
     */
    @JvmName("dbbqgcxcjpjfvime")
    public suspend
    fun rewrite(argument: suspend GatewayRouteSpecHttp2RouteActionRewriteArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteActionRewriteArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rewrite = mapped
    }

    /**
     * @param value Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("fmvhawvinexgljqi")
    public suspend fun target(`value`: GatewayRouteSpecHttp2RouteActionTargetArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Target that traffic is routed to when a request matches the gateway route.
     */
    @JvmName("tfrrmwywqbvahpko")
    public suspend
    fun target(argument: suspend GatewayRouteSpecHttp2RouteActionTargetArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteActionTargetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteActionArgs = GatewayRouteSpecHttp2RouteActionArgs(
        rewrite = rewrite,
        target = target ?: throw PulumiNullFieldException("target"),
    )
}
