@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property hostname Host name to rewrite.
 * @property path Exact path to rewrite.
 * @property prefix Specified beginning characters to rewrite.
 */
public data class GatewayRouteSpecHttp2RouteActionRewriteArgs(
    public val hostname: Output<GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs>? = null,
    public val path: Output<GatewayRouteSpecHttp2RouteActionRewritePathArgs>? = null,
    public val prefix: Output<GatewayRouteSpecHttp2RouteActionRewritePrefixArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewriteArgs.builder()
            .hostname(hostname?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prefix(prefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteActionRewriteArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteActionRewriteArgsBuilder internal constructor() {
    private var hostname: Output<GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs>? = null

    private var path: Output<GatewayRouteSpecHttp2RouteActionRewritePathArgs>? = null

    private var prefix: Output<GatewayRouteSpecHttp2RouteActionRewritePrefixArgs>? = null

    /**
     * @param value Host name to rewrite.
     */
    @JvmName("drnuxwyjdyckpmkc")
    public suspend
    fun hostname(`value`: Output<GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs>) {
        this.hostname = value
    }

    /**
     * @param value Exact path to rewrite.
     */
    @JvmName("ntajnttciiqrlkmk")
    public suspend fun path(`value`: Output<GatewayRouteSpecHttp2RouteActionRewritePathArgs>) {
        this.path = value
    }

    /**
     * @param value Specified beginning characters to rewrite.
     */
    @JvmName("xuicyyqdvwgwroxq")
    public suspend fun prefix(`value`: Output<GatewayRouteSpecHttp2RouteActionRewritePrefixArgs>) {
        this.prefix = value
    }

    /**
     * @param value Host name to rewrite.
     */
    @JvmName("ljsmulqeqrqnjaur")
    public suspend fun hostname(`value`: GatewayRouteSpecHttp2RouteActionRewriteHostnameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param argument Host name to rewrite.
     */
    @JvmName("rrnlygmsyrmudkor")
    public suspend
    fun hostname(argument: suspend GatewayRouteSpecHttp2RouteActionRewriteHostnameArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteActionRewriteHostnameArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hostname = mapped
    }

    /**
     * @param value Exact path to rewrite.
     */
    @JvmName("nkcwdyrydoxvakmw")
    public suspend fun path(`value`: GatewayRouteSpecHttp2RouteActionRewritePathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Exact path to rewrite.
     */
    @JvmName("apnwhfoivyaqbmxj")
    public suspend
    fun path(argument: suspend GatewayRouteSpecHttp2RouteActionRewritePathArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteActionRewritePathArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value Specified beginning characters to rewrite.
     */
    @JvmName("qumllahieycnvxht")
    public suspend fun prefix(`value`: GatewayRouteSpecHttp2RouteActionRewritePrefixArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param argument Specified beginning characters to rewrite.
     */
    @JvmName("doljpjiedyqntulm")
    public suspend
    fun prefix(argument: suspend GatewayRouteSpecHttp2RouteActionRewritePrefixArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteActionRewritePrefixArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.prefix = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteActionRewriteArgs =
        GatewayRouteSpecHttp2RouteActionRewriteArgs(
            hostname = hostname,
            path = path,
            prefix = prefix,
        )
}
