@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exact The exact path to match on.
 */
public data class GatewayRouteSpecHttp2RouteActionRewritePathArgs(
    public val exact: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePathArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePathArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePathArgs.builder()
            .exact(exact.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteActionRewritePathArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteActionRewritePathArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    /**
     * @param value The exact path to match on.
     */
    @JvmName("wakmslccdvjueoso")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value The exact path to match on.
     */
    @JvmName("bpukommweyuisaca")
    public suspend fun exact(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteActionRewritePathArgs =
        GatewayRouteSpecHttp2RouteActionRewritePathArgs(
            exact = exact ?: throw PulumiNullFieldException("exact"),
        )
}
