@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePrefixArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultPrefix Default prefix used to replace the incoming route prefix when rewritten. Valid values: `ENABLED`, `DISABLED`.
 * @property value Value used to replace the incoming route prefix when rewritten.
 */
public data class GatewayRouteSpecHttp2RouteActionRewritePrefixArgs(
    public val defaultPrefix: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePrefixArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePrefixArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionRewritePrefixArgs.builder()
            .defaultPrefix(defaultPrefix?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteActionRewritePrefixArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteActionRewritePrefixArgsBuilder internal constructor() {
    private var defaultPrefix: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Default prefix used to replace the incoming route prefix when rewritten. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("sgwfibnsovjeqego")
    public suspend fun defaultPrefix(`value`: Output<String>) {
        this.defaultPrefix = value
    }

    /**
     * @param value Value used to replace the incoming route prefix when rewritten.
     */
    @JvmName("jyasyedpqmvmlxxd")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Default prefix used to replace the incoming route prefix when rewritten. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("jnepouelchvwpdcd")
    public suspend fun defaultPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultPrefix = mapped
    }

    /**
     * @param value Value used to replace the incoming route prefix when rewritten.
     */
    @JvmName("fcpcupfvjukmxons")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteActionRewritePrefixArgs =
        GatewayRouteSpecHttp2RouteActionRewritePrefixArgs(
            defaultPrefix = defaultPrefix,
            `value` = `value`,
        )
}
