@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property port The port number that corresponds to the target for Virtual Service provider port. This is required when the provider (router or node) of the Virtual Service has multiple listeners.
 * @property virtualService Virtual service gateway route target.
 */
public data class GatewayRouteSpecHttp2RouteActionTargetArgs(
    public val port: Output<Int>? = null,
    public val virtualService: Output<GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteActionTargetArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .virtualService(
                virtualService.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteActionTargetArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteActionTargetArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var virtualService: Output<GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs>? =
        null

    /**
     * @param value The port number that corresponds to the target for Virtual Service provider port. This is required when the provider (router or node) of the Virtual Service has multiple listeners.
     */
    @JvmName("quvactcyldigudhx")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Virtual service gateway route target.
     */
    @JvmName("ouimdottismcogtp")
    public suspend
    fun virtualService(`value`: Output<GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs>) {
        this.virtualService = value
    }

    /**
     * @param value The port number that corresponds to the target for Virtual Service provider port. This is required when the provider (router or node) of the Virtual Service has multiple listeners.
     */
    @JvmName("eqjbkyomgbumdmek")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Virtual service gateway route target.
     */
    @JvmName("ejtpsiwaumsuwrnt")
    public suspend
    fun virtualService(`value`: GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualService = mapped
    }

    /**
     * @param argument Virtual service gateway route target.
     */
    @JvmName("jffqfhsockeibkxm")
    public suspend
    fun virtualService(argument: suspend GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteActionTargetVirtualServiceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.virtualService = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteActionTargetArgs =
        GatewayRouteSpecHttp2RouteActionTargetArgs(
            port = port,
            virtualService = virtualService ?: throw PulumiNullFieldException("virtualService"),
        )
}
