@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property headers Client request headers to match on.
 * @property hostname Host name to match on.
 * @property path Client request path to match on.
 * @property port The port number to match from the request.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property queryParameters Client request query parameters to match on.
 */
public data class GatewayRouteSpecHttp2RouteMatchArgs(
    public val headers: Output<List<GatewayRouteSpecHttp2RouteMatchHeaderArgs>>? = null,
    public val hostname: Output<GatewayRouteSpecHttp2RouteMatchHostnameArgs>? = null,
    public val path: Output<GatewayRouteSpecHttp2RouteMatchPathArgs>? = null,
    public val port: Output<Int>? = null,
    public val prefix: Output<String>? = null,
    public val queryParameters: Output<List<GatewayRouteSpecHttp2RouteMatchQueryParameterArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchArgs.builder()
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hostname(hostname?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .queryParameters(
                queryParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteMatchArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteMatchArgsBuilder internal constructor() {
    private var headers: Output<List<GatewayRouteSpecHttp2RouteMatchHeaderArgs>>? = null

    private var hostname: Output<GatewayRouteSpecHttp2RouteMatchHostnameArgs>? = null

    private var path: Output<GatewayRouteSpecHttp2RouteMatchPathArgs>? = null

    private var port: Output<Int>? = null

    private var prefix: Output<String>? = null

    private var queryParameters: Output<List<GatewayRouteSpecHttp2RouteMatchQueryParameterArgs>>? =
        null

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("qexdpmikhieuylgf")
    public suspend fun headers(`value`: Output<List<GatewayRouteSpecHttp2RouteMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("jbxqefxtkosrxgrj")
    public suspend fun headers(vararg values: Output<GatewayRouteSpecHttp2RouteMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("tppdoldepfircuek")
    public suspend fun headers(values: List<Output<GatewayRouteSpecHttp2RouteMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Host name to match on.
     */
    @JvmName("hjglvrtvmgoumvcn")
    public suspend fun hostname(`value`: Output<GatewayRouteSpecHttp2RouteMatchHostnameArgs>) {
        this.hostname = value
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("fljkrarroeieecxa")
    public suspend fun path(`value`: Output<GatewayRouteSpecHttp2RouteMatchPathArgs>) {
        this.path = value
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("dglrsxjucwglkric")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("bicomcjokrkslsxn")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("kkwgkehxkywxyocb")
    public suspend
    fun queryParameters(`value`: Output<List<GatewayRouteSpecHttp2RouteMatchQueryParameterArgs>>) {
        this.queryParameters = value
    }

    @JvmName("wuaahaoequnbuklt")
    public suspend fun queryParameters(
        vararg
        values: Output<GatewayRouteSpecHttp2RouteMatchQueryParameterArgs>,
    ) {
        this.queryParameters = Output.all(values.asList())
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("kygivqkxftqcihfg")
    public suspend
    fun queryParameters(values: List<Output<GatewayRouteSpecHttp2RouteMatchQueryParameterArgs>>) {
        this.queryParameters = Output.all(values)
    }

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("iubmkltrjplumuwl")
    public suspend fun headers(`value`: List<GatewayRouteSpecHttp2RouteMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("palmbfguykbpakxp")
    public suspend
    fun headers(argument: List<suspend GatewayRouteSpecHttp2RouteMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttp2RouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("pqpmtkvcgjyesyye")
    public suspend fun headers(
        vararg
        argument: suspend GatewayRouteSpecHttp2RouteMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttp2RouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("yktrpwibxwcbflhv")
    public suspend
    fun headers(argument: suspend GatewayRouteSpecHttp2RouteMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayRouteSpecHttp2RouteMatchHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("jusxcbayuqinwiri")
    public suspend fun headers(vararg values: GatewayRouteSpecHttp2RouteMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Host name to match on.
     */
    @JvmName("glanagfwglqauisv")
    public suspend fun hostname(`value`: GatewayRouteSpecHttp2RouteMatchHostnameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostname = mapped
    }

    /**
     * @param argument Host name to match on.
     */
    @JvmName("igsudfshfcyqvhwd")
    public suspend
    fun hostname(argument: suspend GatewayRouteSpecHttp2RouteMatchHostnameArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteMatchHostnameArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hostname = mapped
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("khmactnaymqxmniq")
    public suspend fun path(`value`: GatewayRouteSpecHttp2RouteMatchPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Client request path to match on.
     */
    @JvmName("gnyhuqufucwlgqdg")
    public suspend
    fun path(argument: suspend GatewayRouteSpecHttp2RouteMatchPathArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteMatchPathArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("duuqceimjwfcdqtj")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("wptjrcrrpelwhgmn")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("cpgnpmopqbmvugtn")
    public suspend
    fun queryParameters(`value`: List<GatewayRouteSpecHttp2RouteMatchQueryParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("oultjpwqvknichio")
    public suspend
    fun queryParameters(argument: List<suspend GatewayRouteSpecHttp2RouteMatchQueryParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttp2RouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("xigsnfdtjyvpthxo")
    public suspend fun queryParameters(
        vararg
        argument: suspend GatewayRouteSpecHttp2RouteMatchQueryParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GatewayRouteSpecHttp2RouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("qfsupaoyajvuoabh")
    public suspend
    fun queryParameters(argument: suspend GatewayRouteSpecHttp2RouteMatchQueryParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayRouteSpecHttp2RouteMatchQueryParameterArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("payoytlfdfrdikdh")
    public suspend fun queryParameters(
        vararg
        values: GatewayRouteSpecHttp2RouteMatchQueryParameterArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteMatchArgs = GatewayRouteSpecHttp2RouteMatchArgs(
        headers = headers,
        hostname = hostname,
        path = path,
        port = port,
        prefix = prefix,
        queryParameters = queryParameters,
    )
}
