@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property invert If `true`, the match is on the opposite of the `match` method and value. Default is `false`.
 * @property match Method and value to match the header value sent with a request. Specify one match method.
 * @property name Name for the HTTP header in the client request that will be matched on.
 */
public data class GatewayRouteSpecHttp2RouteMatchHeaderArgs(
    public val invert: Output<Boolean>? = null,
    public val match: Output<GatewayRouteSpecHttp2RouteMatchHeaderMatchArgs>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderArgs.builder()
            .invert(invert?.applyValue({ args0 -> args0 }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteMatchHeaderArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteMatchHeaderArgsBuilder internal constructor() {
    private var invert: Output<Boolean>? = null

    private var match: Output<GatewayRouteSpecHttp2RouteMatchHeaderMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value If `true`, the match is on the opposite of the `match` method and value. Default is `false`.
     */
    @JvmName("bqcbjsreduqlfgff")
    public suspend fun invert(`value`: Output<Boolean>) {
        this.invert = value
    }

    /**
     * @param value Method and value to match the header value sent with a request. Specify one match method.
     */
    @JvmName("tsmtxofnyplsshfu")
    public suspend fun match(`value`: Output<GatewayRouteSpecHttp2RouteMatchHeaderMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name for the HTTP header in the client request that will be matched on.
     */
    @JvmName("uuyjeenqndirudtd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If `true`, the match is on the opposite of the `match` method and value. Default is `false`.
     */
    @JvmName("hmcnxojlelgawtna")
    public suspend fun invert(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invert = mapped
    }

    /**
     * @param value Method and value to match the header value sent with a request. Specify one match method.
     */
    @JvmName("gtwroteqsqlqpeci")
    public suspend fun match(`value`: GatewayRouteSpecHttp2RouteMatchHeaderMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Method and value to match the header value sent with a request. Specify one match method.
     */
    @JvmName("kndksqrelimhnkjs")
    public suspend
    fun match(argument: suspend GatewayRouteSpecHttp2RouteMatchHeaderMatchArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteMatchHeaderMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name for the HTTP header in the client request that will be matched on.
     */
    @JvmName("hobpvrvukmftakuv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteMatchHeaderArgs =
        GatewayRouteSpecHttp2RouteMatchHeaderArgs(
            invert = invert,
            match = match,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
