@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property end End of the range.
 * @property start Start of the range.
 */
public data class GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs(
    public val end: Output<Int>,
    public val start: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs.builder()
            .end(end.applyValue({ args0 -> args0 }))
            .start(start.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgsBuilder internal constructor() {
    private var end: Output<Int>? = null

    private var start: Output<Int>? = null

    /**
     * @param value End of the range.
     */
    @JvmName("jjebcbqjrbxsccdc")
    public suspend fun end(`value`: Output<Int>) {
        this.end = value
    }

    /**
     * @param value Start of the range.
     */
    @JvmName("yahgxljpmcwprhwe")
    public suspend fun start(`value`: Output<Int>) {
        this.start = value
    }

    /**
     * @param value End of the range.
     */
    @JvmName("utsukrjdyvfklufr")
    public suspend fun end(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value Start of the range.
     */
    @JvmName("sdcvtcyxqhepojcr")
    public suspend fun start(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs =
        GatewayRouteSpecHttp2RouteMatchHeaderMatchRangeArgs(
            end = end ?: throw PulumiNullFieldException("end"),
            start = start ?: throw PulumiNullFieldException("start"),
        )
}
