@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exact The exact path to match on.
 * @property regex The regex used to match the path.
 */
public data class GatewayRouteSpecHttp2RouteMatchPathArgs(
    public val exact: Output<String>? = null,
    public val regex: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchPathArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchPathArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchPathArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 }))
            .regex(regex?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteMatchPathArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteMatchPathArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    private var regex: Output<String>? = null

    /**
     * @param value The exact path to match on.
     */
    @JvmName("tbqnmbfkxdqshfmc")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value The regex used to match the path.
     */
    @JvmName("imeqmprgmdnuwist")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value The exact path to match on.
     */
    @JvmName("sugbthycbnrcbvnq")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value The regex used to match the path.
     */
    @JvmName("gtowwitieieylntr")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteMatchPathArgs =
        GatewayRouteSpecHttp2RouteMatchPathArgs(
            exact = exact,
            regex = regex,
        )
}
