@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchQueryParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property match The query parameter to match on.
 * @property name Name for the query parameter that will be matched on.
 */
public data class GatewayRouteSpecHttp2RouteMatchQueryParameterArgs(
    public val match: Output<GatewayRouteSpecHttp2RouteMatchQueryParameterMatchArgs>? = null,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchQueryParameterArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchQueryParameterArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttp2RouteMatchQueryParameterArgs.builder()
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttp2RouteMatchQueryParameterArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttp2RouteMatchQueryParameterArgsBuilder internal constructor() {
    private var match: Output<GatewayRouteSpecHttp2RouteMatchQueryParameterMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The query parameter to match on.
     */
    @JvmName("pgkcawgpqdabfgyu")
    public suspend
    fun match(`value`: Output<GatewayRouteSpecHttp2RouteMatchQueryParameterMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name for the query parameter that will be matched on.
     */
    @JvmName("pwhoyumpwsbtpnev")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The query parameter to match on.
     */
    @JvmName("jhegdrsvagypvkux")
    public suspend fun match(`value`: GatewayRouteSpecHttp2RouteMatchQueryParameterMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument The query parameter to match on.
     */
    @JvmName("eukvkyokyshkdfle")
    public suspend
    fun match(argument: suspend GatewayRouteSpecHttp2RouteMatchQueryParameterMatchArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttp2RouteMatchQueryParameterMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name for the query parameter that will be matched on.
     */
    @JvmName("dpmirtlwmvubfogj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GatewayRouteSpecHttp2RouteMatchQueryParameterArgs =
        GatewayRouteSpecHttp2RouteMatchQueryParameterArgs(
            match = match,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
