@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteHostnameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultTargetHostname Default target host name to write to. Valid values: `ENABLED`, `DISABLED`.
 */
public data class GatewayRouteSpecHttpRouteActionRewriteHostnameArgs(
    public val defaultTargetHostname: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteHostnameArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteHostnameArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionRewriteHostnameArgs.builder()
            .defaultTargetHostname(defaultTargetHostname.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteActionRewriteHostnameArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteActionRewriteHostnameArgsBuilder internal constructor() {
    private var defaultTargetHostname: Output<String>? = null

    /**
     * @param value Default target host name to write to. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("xswjyfyqyotvnbri")
    public suspend fun defaultTargetHostname(`value`: Output<String>) {
        this.defaultTargetHostname = value
    }

    /**
     * @param value Default target host name to write to. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("vdeuqmugndlbqdvr")
    public suspend fun defaultTargetHostname(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultTargetHostname = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteActionRewriteHostnameArgs =
        GatewayRouteSpecHttpRouteActionRewriteHostnameArgs(
            defaultTargetHostname = defaultTargetHostname ?: throw
                PulumiNullFieldException("defaultTargetHostname"),
        )
}
