@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property virtualServiceName Name of the virtual service that traffic is routed to. Must be between 1 and 255 characters in length.
 */
public data class GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs(
    public val virtualServiceName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs.builder()
            .virtualServiceName(virtualServiceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgsBuilder internal constructor() {
    private var virtualServiceName: Output<String>? = null

    /**
     * @param value Name of the virtual service that traffic is routed to. Must be between 1 and 255 characters in length.
     */
    @JvmName("hcfcxoxxohmalnhj")
    public suspend fun virtualServiceName(`value`: Output<String>) {
        this.virtualServiceName = value
    }

    /**
     * @param value Name of the virtual service that traffic is routed to. Must be between 1 and 255 characters in length.
     */
    @JvmName("kgcrnlwlcccnebbb")
    public suspend fun virtualServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualServiceName = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs =
        GatewayRouteSpecHttpRouteActionTargetVirtualServiceArgs(
            virtualServiceName = virtualServiceName ?: throw PulumiNullFieldException("virtualServiceName"),
        )
}
