@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining a request match.
 */
public data class GatewayRouteSpecHttpRouteArgs(
    public val action: Output<GatewayRouteSpecHttpRouteActionArgs>,
    public val match: Output<GatewayRouteSpecHttpRouteMatchArgs>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteArgsBuilder internal constructor() {
    private var action: Output<GatewayRouteSpecHttpRouteActionArgs>? = null

    private var match: Output<GatewayRouteSpecHttpRouteMatchArgs>? = null

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("hrfrrkntuyjgnuaq")
    public suspend fun action(`value`: Output<GatewayRouteSpecHttpRouteActionArgs>) {
        this.action = value
    }

    /**
     * @param value Criteria for determining a request match.
     */
    @JvmName("knnxesynlfiakjut")
    public suspend fun match(`value`: Output<GatewayRouteSpecHttpRouteMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("wxpbgvavomsrilet")
    public suspend fun action(`value`: GatewayRouteSpecHttpRouteActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Action to take if a match is determined.
     */
    @JvmName("nxklecdsamabufyu")
    public suspend
    fun action(argument: suspend GatewayRouteSpecHttpRouteActionArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Criteria for determining a request match.
     */
    @JvmName("tupwnfesieygouag")
    public suspend fun match(`value`: GatewayRouteSpecHttpRouteMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining a request match.
     */
    @JvmName("lktlogjbvgbnhpdp")
    public suspend fun match(argument: suspend GatewayRouteSpecHttpRouteMatchArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteArgs = GatewayRouteSpecHttpRouteArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        match = match ?: throw PulumiNullFieldException("match"),
    )
}
