@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHeaderMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property exact Header value sent by the client must match the specified value exactly.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property range Object that specifies the range of numbers that the header value sent by the client must be included in.
 * @property regex Header value sent by the client must include the specified characters.
 * @property suffix Header value sent by the client must end with the specified characters.
 */
public data class GatewayRouteSpecHttpRouteMatchHeaderMatchArgs(
    public val exact: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val range: Output<GatewayRouteSpecHttpRouteMatchHeaderMatchRangeArgs>? = null,
    public val regex: Output<String>? = null,
    public val suffix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHeaderMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHeaderMatchArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchHeaderMatchArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .range(range?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regex(regex?.applyValue({ args0 -> args0 }))
            .suffix(suffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteMatchHeaderMatchArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteMatchHeaderMatchArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    private var prefix: Output<String>? = null

    private var range: Output<GatewayRouteSpecHttpRouteMatchHeaderMatchRangeArgs>? = null

    private var regex: Output<String>? = null

    private var suffix: Output<String>? = null

    /**
     * @param value Header value sent by the client must match the specified value exactly.
     */
    @JvmName("wrpbjcuqlpfqbiit")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("auuvanykttluomqc")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Object that specifies the range of numbers that the header value sent by the client must be included in.
     */
    @JvmName("houmlitumwkxmrwu")
    public suspend fun range(`value`: Output<GatewayRouteSpecHttpRouteMatchHeaderMatchRangeArgs>) {
        this.range = value
    }

    /**
     * @param value Header value sent by the client must include the specified characters.
     */
    @JvmName("pjibcandxbpfcmjf")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value Header value sent by the client must end with the specified characters.
     */
    @JvmName("dfgdwgcrqdlapoej")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value Header value sent by the client must match the specified value exactly.
     */
    @JvmName("vfwvsitjampcwmbd")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("xeanvqjxeaodteyk")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Object that specifies the range of numbers that the header value sent by the client must be included in.
     */
    @JvmName("hycgjadolwnixska")
    public suspend fun range(`value`: GatewayRouteSpecHttpRouteMatchHeaderMatchRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.range = mapped
    }

    /**
     * @param argument Object that specifies the range of numbers that the header value sent by the client must be included in.
     */
    @JvmName("dygsxjjxrwhivsrf")
    public suspend
    fun range(argument: suspend GatewayRouteSpecHttpRouteMatchHeaderMatchRangeArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteMatchHeaderMatchRangeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.range = mapped
    }

    /**
     * @param value Header value sent by the client must include the specified characters.
     */
    @JvmName("cjkfjhnhkeehtxxp")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    /**
     * @param value Header value sent by the client must end with the specified characters.
     */
    @JvmName("omhquvvpglvemiqy")
    public suspend fun suffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteMatchHeaderMatchArgs =
        GatewayRouteSpecHttpRouteMatchHeaderMatchArgs(
            exact = exact,
            prefix = prefix,
            range = range,
            regex = regex,
            suffix = suffix,
        )
}
