@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property match The query parameter to match on.
 * @property name Name for the query parameter that will be matched on.
 */
public data class GatewayRouteSpecHttpRouteMatchQueryParameterArgs(
    public val match: Output<GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs>? = null,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterArgs =
        com.pulumi.aws.appmesh.inputs.GatewayRouteSpecHttpRouteMatchQueryParameterArgs.builder()
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteSpecHttpRouteMatchQueryParameterArgs].
 */
@PulumiTagMarker
public class GatewayRouteSpecHttpRouteMatchQueryParameterArgsBuilder internal constructor() {
    private var match: Output<GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value The query parameter to match on.
     */
    @JvmName("qmviygiylhvpflwy")
    public suspend fun match(`value`: Output<GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name for the query parameter that will be matched on.
     */
    @JvmName("bcwjhjholqbkyjkd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The query parameter to match on.
     */
    @JvmName("iyafcmtmjvccywmb")
    public suspend fun match(`value`: GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument The query parameter to match on.
     */
    @JvmName("parpesotgckigqnx")
    public suspend
    fun match(argument: suspend GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteSpecHttpRouteMatchQueryParameterMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name for the query parameter that will be matched on.
     */
    @JvmName("quqhadflnepnwyhd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GatewayRouteSpecHttpRouteMatchQueryParameterArgs =
        GatewayRouteSpecHttpRouteMatchQueryParameterArgs(
            match = match,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
