@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GetGatewayRoutePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGatewayRoute.
 * @property meshName Name of the service mesh in which the virtual gateway exists.
 * @property meshOwner AWS account ID of the service mesh's owner.
 * @property name Name of the gateway route.
 * @property tags Map of tags.
 * @property virtualGatewayName Name of the virtual gateway in which the route exists.
 */
public data class GetGatewayRoutePlainArgs(
    public val meshName: String,
    public val meshOwner: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val virtualGatewayName: String,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GetGatewayRoutePlainArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GetGatewayRoutePlainArgs =
        com.pulumi.aws.appmesh.inputs.GetGatewayRoutePlainArgs.builder()
            .meshName(meshName.let({ args0 -> args0 }))
            .meshOwner(meshOwner?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualGatewayName(virtualGatewayName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayRoutePlainArgs].
 */
@PulumiTagMarker
public class GetGatewayRoutePlainArgsBuilder internal constructor() {
    private var meshName: String? = null

    private var meshOwner: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    private var virtualGatewayName: String? = null

    /**
     * @param value Name of the service mesh in which the virtual gateway exists.
     */
    @JvmName("rkgjggtoemisyfot")
    public suspend fun meshName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner.
     */
    @JvmName("uxsxdtvgelavofdt")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.meshOwner = mapped
    }

    /**
     * @param value Name of the gateway route.
     */
    @JvmName("rdmlmtaoraachoae")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags.
     */
    @JvmName("hkljaxwtrhiecchy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags.
     */
    @JvmName("insldovfahljeydx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Name of the virtual gateway in which the route exists.
     */
    @JvmName("cblkykykioibfcos")
    public suspend fun virtualGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualGatewayName = mapped
    }

    internal fun build(): GetGatewayRoutePlainArgs = GetGatewayRoutePlainArgs(
        meshName = meshName ?: throw PulumiNullFieldException("meshName"),
        meshOwner = meshOwner,
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
        virtualGatewayName = virtualGatewayName ?: throw PulumiNullFieldException("virtualGatewayName"),
    )
}
