@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GetMeshPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMesh.
 * @property meshOwner AWS account ID of the service mesh's owner.
 * @property name Name of the service mesh.
 * @property tags Map of tags.
 */
public data class GetMeshPlainArgs(
    public val meshOwner: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GetMeshPlainArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GetMeshPlainArgs =
        com.pulumi.aws.appmesh.inputs.GetMeshPlainArgs.builder()
            .meshOwner(meshOwner?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetMeshPlainArgs].
 */
@PulumiTagMarker
public class GetMeshPlainArgsBuilder internal constructor() {
    private var meshOwner: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value AWS account ID of the service mesh's owner.
     */
    @JvmName("bfdgxpmvlpqvggld")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.meshOwner = mapped
    }

    /**
     * @param value Name of the service mesh.
     */
    @JvmName("gomxtjsrnyoofqin")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags.
     */
    @JvmName("qvurwlehxphqdxig")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags.
     */
    @JvmName("aeigtaeorhiftyyy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetMeshPlainArgs = GetMeshPlainArgs(
        meshOwner = meshOwner,
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
