@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GetRoutePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRoute.
 * @property meshName Name of the service mesh in which the virtual router exists.
 * @property meshOwner AWS account ID of the service mesh's owner.
 * @property name Name of the route.
 * @property tags Map of tags.
 * @property virtualRouterName Name of the virtual router in which the route exists.
 */
public data class GetRoutePlainArgs(
    public val meshName: String,
    public val meshOwner: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val virtualRouterName: String,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GetRoutePlainArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GetRoutePlainArgs =
        com.pulumi.aws.appmesh.inputs.GetRoutePlainArgs.builder()
            .meshName(meshName.let({ args0 -> args0 }))
            .meshOwner(meshOwner?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualRouterName(virtualRouterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoutePlainArgs].
 */
@PulumiTagMarker
public class GetRoutePlainArgsBuilder internal constructor() {
    private var meshName: String? = null

    private var meshOwner: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    private var virtualRouterName: String? = null

    /**
     * @param value Name of the service mesh in which the virtual router exists.
     */
    @JvmName("ogridoioforijawy")
    public suspend fun meshName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.meshName = mapped
    }

    /**
     * @param value AWS account ID of the service mesh's owner.
     */
    @JvmName("sxevojjapbjlrcps")
    public suspend fun meshOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.meshOwner = mapped
    }

    /**
     * @param value Name of the route.
     */
    @JvmName("rvxsuxamfkpvwebd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags.
     */
    @JvmName("icooyrabekdsxpja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags.
     */
    @JvmName("qxogicjgrxtyntxq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Name of the virtual router in which the route exists.
     */
    @JvmName("iqxqcxlljpeygomt")
    public suspend fun virtualRouterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualRouterName = mapped
    }

    internal fun build(): GetRoutePlainArgs = GetRoutePlainArgs(
        meshName = meshName ?: throw PulumiNullFieldException("meshName"),
        meshOwner = meshOwner,
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
        virtualRouterName = virtualRouterName ?: throw PulumiNullFieldException("virtualRouterName"),
    )
}
