@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.GetVirtualGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVirtualGateway.
 * @property meshName Name of the service mesh in which the virtual gateway exists.
 * @property name Name of the virtual gateway.
 * @property tags Map of tags.
 */
public data class GetVirtualGatewayPlainArgs(
    public val meshName: String,
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.GetVirtualGatewayPlainArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.GetVirtualGatewayPlainArgs =
        com.pulumi.aws.appmesh.inputs.GetVirtualGatewayPlainArgs.builder()
            .meshName(meshName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVirtualGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualGatewayPlainArgsBuilder internal constructor() {
    private var meshName: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the service mesh in which the virtual gateway exists.
     */
    @JvmName("arujelbrglyodhhs")
    public suspend fun meshName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.meshName = mapped
    }

    /**
     * @param value Name of the virtual gateway.
     */
    @JvmName("foiomxlbaegiouev")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags.
     */
    @JvmName("dksirqbndatlhvoq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags.
     */
    @JvmName("koeautikruxapfjq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVirtualGatewayPlainArgs = GetVirtualGatewayPlainArgs(
        meshName = meshName ?: throw PulumiNullFieldException("meshName"),
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
