@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.MeshSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property egressFilter Egress filter rules for the service mesh.
 */
public data class MeshSpecArgs(
    public val egressFilter: Output<MeshSpecEgressFilterArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.MeshSpecArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.MeshSpecArgs =
        com.pulumi.aws.appmesh.inputs.MeshSpecArgs.builder()
            .egressFilter(egressFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MeshSpecArgs].
 */
@PulumiTagMarker
public class MeshSpecArgsBuilder internal constructor() {
    private var egressFilter: Output<MeshSpecEgressFilterArgs>? = null

    /**
     * @param value Egress filter rules for the service mesh.
     */
    @JvmName("jwtwcppjrogjabqo")
    public suspend fun egressFilter(`value`: Output<MeshSpecEgressFilterArgs>) {
        this.egressFilter = value
    }

    /**
     * @param value Egress filter rules for the service mesh.
     */
    @JvmName("bbokplpbxontjnuc")
    public suspend fun egressFilter(`value`: MeshSpecEgressFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressFilter = mapped
    }

    /**
     * @param argument Egress filter rules for the service mesh.
     */
    @JvmName("fbrwsmfvfejxjaak")
    public suspend fun egressFilter(argument: suspend MeshSpecEgressFilterArgsBuilder.() -> Unit) {
        val toBeMapped = MeshSpecEgressFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.egressFilter = mapped
    }

    internal fun build(): MeshSpecArgs = MeshSpecArgs(
        egressFilter = egressFilter,
    )
}
