@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property weightedTargets Targets that traffic is routed to when a request matches the route.
 * You can specify one or more targets and their relative weights with which to distribute traffic.
 */
public data class RouteSpecGrpcRouteActionArgs(
    public val weightedTargets: Output<List<RouteSpecGrpcRouteActionWeightedTargetArgs>>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteActionArgs.builder()
            .weightedTargets(
                weightedTargets.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RouteSpecGrpcRouteActionArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteActionArgsBuilder internal constructor() {
    private var weightedTargets: Output<List<RouteSpecGrpcRouteActionWeightedTargetArgs>>? = null

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("lbrhxcvllhnjpbul")
    public suspend
    fun weightedTargets(`value`: Output<List<RouteSpecGrpcRouteActionWeightedTargetArgs>>) {
        this.weightedTargets = value
    }

    @JvmName("gaxrgigitmahwkof")
    public suspend fun weightedTargets(
        vararg
        values: Output<RouteSpecGrpcRouteActionWeightedTargetArgs>,
    ) {
        this.weightedTargets = Output.all(values.asList())
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("flenidlfjgqlvpvv")
    public suspend
    fun weightedTargets(values: List<Output<RouteSpecGrpcRouteActionWeightedTargetArgs>>) {
        this.weightedTargets = Output.all(values)
    }

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("cydfokcvpmqaoscf")
    public suspend fun weightedTargets(`value`: List<RouteSpecGrpcRouteActionWeightedTargetArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("ufplsqcvdtsnmaaj")
    public suspend
    fun weightedTargets(argument: List<suspend RouteSpecGrpcRouteActionWeightedTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecGrpcRouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("yfjydlcqypnkbsbf")
    public suspend fun weightedTargets(
        vararg
        argument: suspend RouteSpecGrpcRouteActionWeightedTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteSpecGrpcRouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("ppydaiwveycnrkul")
    public suspend
    fun weightedTargets(argument: suspend RouteSpecGrpcRouteActionWeightedTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecGrpcRouteActionWeightedTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("oxhbpcirywutdeik")
    public suspend fun weightedTargets(vararg values: RouteSpecGrpcRouteActionWeightedTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    internal fun build(): RouteSpecGrpcRouteActionArgs = RouteSpecGrpcRouteActionArgs(
        weightedTargets = weightedTargets ?: throw PulumiNullFieldException("weightedTargets"),
    )
}
