@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property grpcRetryEvents List of gRPC retry events.
 * Valid values: `cancelled`, `deadline-exceeded`, `internal`, `resource-exhausted`, `unavailable`.
 * @property httpRetryEvents List of HTTP retry events.
 * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
 * @property maxRetries Maximum number of retries.
 * @property perRetryTimeout Per-retry timeout.
 * @property tcpRetryEvents List of TCP retry events. The only valid value is `connection-error`.
 */
public data class RouteSpecGrpcRouteRetryPolicyArgs(
    public val grpcRetryEvents: Output<List<String>>? = null,
    public val httpRetryEvents: Output<List<String>>? = null,
    public val maxRetries: Output<Int>,
    public val perRetryTimeout: Output<RouteSpecGrpcRouteRetryPolicyPerRetryTimeoutArgs>,
    public val tcpRetryEvents: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteRetryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteRetryPolicyArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecGrpcRouteRetryPolicyArgs.builder()
            .grpcRetryEvents(grpcRetryEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpRetryEvents(httpRetryEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxRetries(maxRetries.applyValue({ args0 -> args0 }))
            .perRetryTimeout(perRetryTimeout.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tcpRetryEvents(tcpRetryEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RouteSpecGrpcRouteRetryPolicyArgs].
 */
@PulumiTagMarker
public class RouteSpecGrpcRouteRetryPolicyArgsBuilder internal constructor() {
    private var grpcRetryEvents: Output<List<String>>? = null

    private var httpRetryEvents: Output<List<String>>? = null

    private var maxRetries: Output<Int>? = null

    private var perRetryTimeout: Output<RouteSpecGrpcRouteRetryPolicyPerRetryTimeoutArgs>? = null

    private var tcpRetryEvents: Output<List<String>>? = null

    /**
     * @param value List of gRPC retry events.
     * Valid values: `cancelled`, `deadline-exceeded`, `internal`, `resource-exhausted`, `unavailable`.
     */
    @JvmName("hbfgrutqeomshksn")
    public suspend fun grpcRetryEvents(`value`: Output<List<String>>) {
        this.grpcRetryEvents = value
    }

    @JvmName("bbybknpjrhftospc")
    public suspend fun grpcRetryEvents(vararg values: Output<String>) {
        this.grpcRetryEvents = Output.all(values.asList())
    }

    /**
     * @param values List of gRPC retry events.
     * Valid values: `cancelled`, `deadline-exceeded`, `internal`, `resource-exhausted`, `unavailable`.
     */
    @JvmName("idcqbrvbkmlpikdn")
    public suspend fun grpcRetryEvents(values: List<Output<String>>) {
        this.grpcRetryEvents = Output.all(values)
    }

    /**
     * @param value List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("sbtvcuhdwsocmijc")
    public suspend fun httpRetryEvents(`value`: Output<List<String>>) {
        this.httpRetryEvents = value
    }

    @JvmName("xyxrskuajvdferou")
    public suspend fun httpRetryEvents(vararg values: Output<String>) {
        this.httpRetryEvents = Output.all(values.asList())
    }

    /**
     * @param values List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("rxhcuplxubvbrhar")
    public suspend fun httpRetryEvents(values: List<Output<String>>) {
        this.httpRetryEvents = Output.all(values)
    }

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("clwnjxqpryxycqac")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value Per-retry timeout.
     */
    @JvmName("xcsasaagmrqopnif")
    public suspend
    fun perRetryTimeout(`value`: Output<RouteSpecGrpcRouteRetryPolicyPerRetryTimeoutArgs>) {
        this.perRetryTimeout = value
    }

    /**
     * @param value List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("nalupplblnruomhe")
    public suspend fun tcpRetryEvents(`value`: Output<List<String>>) {
        this.tcpRetryEvents = value
    }

    @JvmName("bnwpqwesuobgfgow")
    public suspend fun tcpRetryEvents(vararg values: Output<String>) {
        this.tcpRetryEvents = Output.all(values.asList())
    }

    /**
     * @param values List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("ipfblfigdncwrwwf")
    public suspend fun tcpRetryEvents(values: List<Output<String>>) {
        this.tcpRetryEvents = Output.all(values)
    }

    /**
     * @param value List of gRPC retry events.
     * Valid values: `cancelled`, `deadline-exceeded`, `internal`, `resource-exhausted`, `unavailable`.
     */
    @JvmName("tdqnrvmwavjdkath")
    public suspend fun grpcRetryEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grpcRetryEvents = mapped
    }

    /**
     * @param values List of gRPC retry events.
     * Valid values: `cancelled`, `deadline-exceeded`, `internal`, `resource-exhausted`, `unavailable`.
     */
    @JvmName("bajnfwqvnadqkcri")
    public suspend fun grpcRetryEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grpcRetryEvents = mapped
    }

    /**
     * @param value List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("yninkwoewrsasmkl")
    public suspend fun httpRetryEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRetryEvents = mapped
    }

    /**
     * @param values List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("vkakbkqnxahhawjp")
    public suspend fun httpRetryEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpRetryEvents = mapped
    }

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("yfipsglgijflajhw")
    public suspend fun maxRetries(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value Per-retry timeout.
     */
    @JvmName("vivaeexyrxhjtwcd")
    public suspend fun perRetryTimeout(`value`: RouteSpecGrpcRouteRetryPolicyPerRetryTimeoutArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.perRetryTimeout = mapped
    }

    /**
     * @param argument Per-retry timeout.
     */
    @JvmName("ybklogwaddbaxsgg")
    public suspend
    fun perRetryTimeout(argument: suspend RouteSpecGrpcRouteRetryPolicyPerRetryTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecGrpcRouteRetryPolicyPerRetryTimeoutArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRetryTimeout = mapped
    }

    /**
     * @param value List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("kfmlilkurqeegckf")
    public suspend fun tcpRetryEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpRetryEvents = mapped
    }

    /**
     * @param values List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("yjfdcvpypajvyfie")
    public suspend fun tcpRetryEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcpRetryEvents = mapped
    }

    internal fun build(): RouteSpecGrpcRouteRetryPolicyArgs = RouteSpecGrpcRouteRetryPolicyArgs(
        grpcRetryEvents = grpcRetryEvents,
        httpRetryEvents = httpRetryEvents,
        maxRetries = maxRetries ?: throw PulumiNullFieldException("maxRetries"),
        perRetryTimeout = perRetryTimeout ?: throw PulumiNullFieldException("perRetryTimeout"),
        tcpRetryEvents = tcpRetryEvents,
    )
}
