@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining an gRPC request match.
 * @property retryPolicy Retry policy.
 * @property timeout Types of timeouts.
 */
public data class RouteSpecHttp2RouteArgs(
    public val action: Output<RouteSpecHttp2RouteActionArgs>,
    public val match: Output<RouteSpecHttp2RouteMatchArgs>,
    public val retryPolicy: Output<RouteSpecHttp2RouteRetryPolicyArgs>? = null,
    public val timeout: Output<RouteSpecHttp2RouteTimeoutArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeout(timeout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteArgsBuilder internal constructor() {
    private var action: Output<RouteSpecHttp2RouteActionArgs>? = null

    private var match: Output<RouteSpecHttp2RouteMatchArgs>? = null

    private var retryPolicy: Output<RouteSpecHttp2RouteRetryPolicyArgs>? = null

    private var timeout: Output<RouteSpecHttp2RouteTimeoutArgs>? = null

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("qfoxwfixweonvkkp")
    public suspend fun action(`value`: Output<RouteSpecHttp2RouteActionArgs>) {
        this.action = value
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("csxpfrrgrgeftgbu")
    public suspend fun match(`value`: Output<RouteSpecHttp2RouteMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Retry policy.
     */
    @JvmName("fcreeopygmhvdqoq")
    public suspend fun retryPolicy(`value`: Output<RouteSpecHttp2RouteRetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("egpawbblhblhgmmk")
    public suspend fun timeout(`value`: Output<RouteSpecHttp2RouteTimeoutArgs>) {
        this.timeout = value
    }

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("xjuphhexqreikvmy")
    public suspend fun action(`value`: RouteSpecHttp2RouteActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Action to take if a match is determined.
     */
    @JvmName("vhwjpcdsvmdqanvs")
    public suspend fun action(argument: suspend RouteSpecHttp2RouteActionArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("hpwgmwbdgjihslpe")
    public suspend fun match(`value`: RouteSpecHttp2RouteMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining an gRPC request match.
     */
    @JvmName("ryjqpbqpshskasrg")
    public suspend fun match(argument: suspend RouteSpecHttp2RouteMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Retry policy.
     */
    @JvmName("wjouwepqiqonpdig")
    public suspend fun retryPolicy(`value`: RouteSpecHttp2RouteRetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument Retry policy.
     */
    @JvmName("nrqnsvpkyxjevahp")
    public suspend
    fun retryPolicy(argument: suspend RouteSpecHttp2RouteRetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteRetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("pustpslbrgjrlkks")
    public suspend fun timeout(`value`: RouteSpecHttp2RouteTimeoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param argument Types of timeouts.
     */
    @JvmName("dlheruhfimucxwui")
    public suspend fun timeout(argument: suspend RouteSpecHttp2RouteTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteTimeoutArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeout = mapped
    }

    internal fun build(): RouteSpecHttp2RouteArgs = RouteSpecHttp2RouteArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        match = match ?: throw PulumiNullFieldException("match"),
        retryPolicy = retryPolicy,
        timeout = timeout,
    )
}
