@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property headers Client request headers to match on.
 * @property method Client request header method to match on. Valid values: `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`, `PATCH`.
 * @property path Client request path to match on.
 * @property port The port number to match from the request.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property queryParameters Client request query parameters to match on.
 * @property scheme Client request header scheme to match on. Valid values: `http`, `https`.
 */
public data class RouteSpecHttp2RouteMatchArgs(
    public val headers: Output<List<RouteSpecHttp2RouteMatchHeaderArgs>>? = null,
    public val method: Output<String>? = null,
    public val path: Output<RouteSpecHttp2RouteMatchPathArgs>? = null,
    public val port: Output<Int>? = null,
    public val prefix: Output<String>? = null,
    public val queryParameters: Output<List<RouteSpecHttp2RouteMatchQueryParameterArgs>>? = null,
    public val scheme: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchArgs.builder()
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .method(method?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .queryParameters(
                queryParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scheme(scheme?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteMatchArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteMatchArgsBuilder internal constructor() {
    private var headers: Output<List<RouteSpecHttp2RouteMatchHeaderArgs>>? = null

    private var method: Output<String>? = null

    private var path: Output<RouteSpecHttp2RouteMatchPathArgs>? = null

    private var port: Output<Int>? = null

    private var prefix: Output<String>? = null

    private var queryParameters: Output<List<RouteSpecHttp2RouteMatchQueryParameterArgs>>? = null

    private var scheme: Output<String>? = null

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("obfwfrvfcvftuxik")
    public suspend fun headers(`value`: Output<List<RouteSpecHttp2RouteMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("ichwyqxmipkdtwdq")
    public suspend fun headers(vararg values: Output<RouteSpecHttp2RouteMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("lujshwhcpgnlbmis")
    public suspend fun headers(values: List<Output<RouteSpecHttp2RouteMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Client request header method to match on. Valid values: `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`, `PATCH`.
     */
    @JvmName("bvjohmqnhqhbdwyw")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("uswcrfwmooxsewhb")
    public suspend fun path(`value`: Output<RouteSpecHttp2RouteMatchPathArgs>) {
        this.path = value
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("swciwcdajveiikxe")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("yyeighkxygvsrknj")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("xnjmnbnucijaujco")
    public suspend
    fun queryParameters(`value`: Output<List<RouteSpecHttp2RouteMatchQueryParameterArgs>>) {
        this.queryParameters = value
    }

    @JvmName("pmkrdmuynmeweaau")
    public suspend fun queryParameters(
        vararg
        values: Output<RouteSpecHttp2RouteMatchQueryParameterArgs>,
    ) {
        this.queryParameters = Output.all(values.asList())
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("mcdskpccknfbtedw")
    public suspend
    fun queryParameters(values: List<Output<RouteSpecHttp2RouteMatchQueryParameterArgs>>) {
        this.queryParameters = Output.all(values)
    }

    /**
     * @param value Client request header scheme to match on. Valid values: `http`, `https`.
     */
    @JvmName("uicfcglrnvqwwafx")
    public suspend fun scheme(`value`: Output<String>) {
        this.scheme = value
    }

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("yynngknoswwtkshn")
    public suspend fun headers(`value`: List<RouteSpecHttp2RouteMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("mvwmrkyxjxdykusn")
    public suspend
    fun headers(argument: List<suspend RouteSpecHttp2RouteMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttp2RouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("ogixqrrrkqayilvx")
    public suspend fun headers(
        vararg
        argument: suspend RouteSpecHttp2RouteMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttp2RouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("iwhrpiwhiwgboexb")
    public suspend
    fun headers(argument: suspend RouteSpecHttp2RouteMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecHttp2RouteMatchHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("qrvvjpntaelnbmjn")
    public suspend fun headers(vararg values: RouteSpecHttp2RouteMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Client request header method to match on. Valid values: `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`, `PATCH`.
     */
    @JvmName("sgmddoyqsrpueojk")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("afykfulwwnimmpid")
    public suspend fun path(`value`: RouteSpecHttp2RouteMatchPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Client request path to match on.
     */
    @JvmName("kiqibhmvccielnfo")
    public suspend fun path(argument: suspend RouteSpecHttp2RouteMatchPathArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteMatchPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("sveyeqrpxnydhkag")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("vcflucppojkqvlgu")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("irhampxnpurkousv")
    public suspend fun queryParameters(`value`: List<RouteSpecHttp2RouteMatchQueryParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("bhnguutviqshbmge")
    public suspend
    fun queryParameters(argument: List<suspend RouteSpecHttp2RouteMatchQueryParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttp2RouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("olinuewqyfmubeim")
    public suspend fun queryParameters(
        vararg
        argument: suspend RouteSpecHttp2RouteMatchQueryParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttp2RouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("jbaheapeesnbxgby")
    public suspend
    fun queryParameters(argument: suspend RouteSpecHttp2RouteMatchQueryParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecHttp2RouteMatchQueryParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("qrdgldrddkhnupvu")
    public suspend fun queryParameters(vararg values: RouteSpecHttp2RouteMatchQueryParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param value Client request header scheme to match on. Valid values: `http`, `https`.
     */
    @JvmName("gwpstliwwhqjpgdo")
    public suspend fun scheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): RouteSpecHttp2RouteMatchArgs = RouteSpecHttp2RouteMatchArgs(
        headers = headers,
        method = method,
        path = path,
        port = port,
        prefix = prefix,
        queryParameters = queryParameters,
        scheme = scheme,
    )
}
