@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property invert If `true`, the match is on the opposite of the `match` method and value. Default is `false`.
 * @property match Method and value to match the header value sent with a request. Specify one match method.
 * @property name Name for the HTTP header in the client request that will be matched on.
 */
public data class RouteSpecHttp2RouteMatchHeaderArgs(
    public val invert: Output<Boolean>? = null,
    public val match: Output<RouteSpecHttp2RouteMatchHeaderMatchArgs>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchHeaderArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchHeaderArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchHeaderArgs.builder()
            .invert(invert?.applyValue({ args0 -> args0 }))
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteMatchHeaderArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteMatchHeaderArgsBuilder internal constructor() {
    private var invert: Output<Boolean>? = null

    private var match: Output<RouteSpecHttp2RouteMatchHeaderMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value If `true`, the match is on the opposite of the `match` method and value. Default is `false`.
     */
    @JvmName("nrllkxiribtmtfqf")
    public suspend fun invert(`value`: Output<Boolean>) {
        this.invert = value
    }

    /**
     * @param value Method and value to match the header value sent with a request. Specify one match method.
     */
    @JvmName("yrhtqyfvrrusslmf")
    public suspend fun match(`value`: Output<RouteSpecHttp2RouteMatchHeaderMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name for the HTTP header in the client request that will be matched on.
     */
    @JvmName("shtnoqhdeiqqvcet")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value If `true`, the match is on the opposite of the `match` method and value. Default is `false`.
     */
    @JvmName("vkyqpdovfogcdiua")
    public suspend fun invert(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invert = mapped
    }

    /**
     * @param value Method and value to match the header value sent with a request. Specify one match method.
     */
    @JvmName("fgbebxjufjtmvwhk")
    public suspend fun match(`value`: RouteSpecHttp2RouteMatchHeaderMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Method and value to match the header value sent with a request. Specify one match method.
     */
    @JvmName("buujininapdmihix")
    public suspend
    fun match(argument: suspend RouteSpecHttp2RouteMatchHeaderMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteMatchHeaderMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name for the HTTP header in the client request that will be matched on.
     */
    @JvmName("ionbkljtdwfbhyku")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RouteSpecHttp2RouteMatchHeaderArgs = RouteSpecHttp2RouteMatchHeaderArgs(
        invert = invert,
        match = match,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
