@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exact Header value sent by the client must match the specified value exactly.
 * @property regex Header value sent by the client must include the specified characters.
 */
public data class RouteSpecHttp2RouteMatchPathArgs(
    public val exact: Output<String>? = null,
    public val regex: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchPathArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchPathArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchPathArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 }))
            .regex(regex?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteMatchPathArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteMatchPathArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    private var regex: Output<String>? = null

    /**
     * @param value Header value sent by the client must match the specified value exactly.
     */
    @JvmName("hunnhichsmvwpfxa")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value Header value sent by the client must include the specified characters.
     */
    @JvmName("vglqcngxmlkdbsrn")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value Header value sent by the client must match the specified value exactly.
     */
    @JvmName("pfkpfeeoncixhrnb")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value Header value sent by the client must include the specified characters.
     */
    @JvmName("mrbxdxjnameccmis")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    internal fun build(): RouteSpecHttp2RouteMatchPathArgs = RouteSpecHttp2RouteMatchPathArgs(
        exact = exact,
        regex = regex,
    )
}
