@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchQueryParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property match Criteria for determining an gRPC request match.
 * @property name Name to use for the route. Must be between 1 and 255 characters in length.
 */
public data class RouteSpecHttp2RouteMatchQueryParameterArgs(
    public val match: Output<RouteSpecHttp2RouteMatchQueryParameterMatchArgs>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchQueryParameterArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchQueryParameterArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteMatchQueryParameterArgs.builder()
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteMatchQueryParameterArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteMatchQueryParameterArgsBuilder internal constructor() {
    private var match: Output<RouteSpecHttp2RouteMatchQueryParameterMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("slwrmeanwrbwsxvc")
    public suspend fun match(`value`: Output<RouteSpecHttp2RouteMatchQueryParameterMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name to use for the route. Must be between 1 and 255 characters in length.
     */
    @JvmName("vsfkjqllvqblguji")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("yulgauxdhktstotk")
    public suspend fun match(`value`: RouteSpecHttp2RouteMatchQueryParameterMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining an gRPC request match.
     */
    @JvmName("biqvjsifsuvbwqxf")
    public suspend
    fun match(argument: suspend RouteSpecHttp2RouteMatchQueryParameterMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteMatchQueryParameterMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name to use for the route. Must be between 1 and 255 characters in length.
     */
    @JvmName("deojpqlifecaouqr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RouteSpecHttp2RouteMatchQueryParameterArgs =
        RouteSpecHttp2RouteMatchQueryParameterArgs(
            match = match,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
