@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property httpRetryEvents List of HTTP retry events.
 * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
 * @property maxRetries Maximum number of retries.
 * @property perRetryTimeout Per-retry timeout.
 * @property tcpRetryEvents List of TCP retry events. The only valid value is `connection-error`.
 */
public data class RouteSpecHttp2RouteRetryPolicyArgs(
    public val httpRetryEvents: Output<List<String>>? = null,
    public val maxRetries: Output<Int>,
    public val perRetryTimeout: Output<RouteSpecHttp2RouteRetryPolicyPerRetryTimeoutArgs>,
    public val tcpRetryEvents: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteRetryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteRetryPolicyArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteRetryPolicyArgs.builder()
            .httpRetryEvents(httpRetryEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxRetries(maxRetries.applyValue({ args0 -> args0 }))
            .perRetryTimeout(perRetryTimeout.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tcpRetryEvents(tcpRetryEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteRetryPolicyArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteRetryPolicyArgsBuilder internal constructor() {
    private var httpRetryEvents: Output<List<String>>? = null

    private var maxRetries: Output<Int>? = null

    private var perRetryTimeout: Output<RouteSpecHttp2RouteRetryPolicyPerRetryTimeoutArgs>? = null

    private var tcpRetryEvents: Output<List<String>>? = null

    /**
     * @param value List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("dhwcgthbviwkvvsk")
    public suspend fun httpRetryEvents(`value`: Output<List<String>>) {
        this.httpRetryEvents = value
    }

    @JvmName("proswbhskpmcvjum")
    public suspend fun httpRetryEvents(vararg values: Output<String>) {
        this.httpRetryEvents = Output.all(values.asList())
    }

    /**
     * @param values List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("yghisngkyinxbxgg")
    public suspend fun httpRetryEvents(values: List<Output<String>>) {
        this.httpRetryEvents = Output.all(values)
    }

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("kbfyqmkqqoqtvdcv")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value Per-retry timeout.
     */
    @JvmName("wmbgapdwjttnguka")
    public suspend
    fun perRetryTimeout(`value`: Output<RouteSpecHttp2RouteRetryPolicyPerRetryTimeoutArgs>) {
        this.perRetryTimeout = value
    }

    /**
     * @param value List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("firrnwsvsktkmoaf")
    public suspend fun tcpRetryEvents(`value`: Output<List<String>>) {
        this.tcpRetryEvents = value
    }

    @JvmName("ggceeurhfptgemgq")
    public suspend fun tcpRetryEvents(vararg values: Output<String>) {
        this.tcpRetryEvents = Output.all(values.asList())
    }

    /**
     * @param values List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("rsxanxrvbemwjypr")
    public suspend fun tcpRetryEvents(values: List<Output<String>>) {
        this.tcpRetryEvents = Output.all(values)
    }

    /**
     * @param value List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("yxqpwkartoufirvq")
    public suspend fun httpRetryEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRetryEvents = mapped
    }

    /**
     * @param values List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("ptkwkywuubkrhxxy")
    public suspend fun httpRetryEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpRetryEvents = mapped
    }

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("spvlcfgmwtciylgn")
    public suspend fun maxRetries(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value Per-retry timeout.
     */
    @JvmName("smjvwyxxrihhlxxi")
    public suspend fun perRetryTimeout(`value`: RouteSpecHttp2RouteRetryPolicyPerRetryTimeoutArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.perRetryTimeout = mapped
    }

    /**
     * @param argument Per-retry timeout.
     */
    @JvmName("whfoglrcarlhtwsj")
    public suspend
    fun perRetryTimeout(argument: suspend RouteSpecHttp2RouteRetryPolicyPerRetryTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteRetryPolicyPerRetryTimeoutArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRetryTimeout = mapped
    }

    /**
     * @param value List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("yoqlmoqeiqyuppon")
    public suspend fun tcpRetryEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpRetryEvents = mapped
    }

    /**
     * @param values List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("rxvdxjnxfhxviwic")
    public suspend fun tcpRetryEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcpRetryEvents = mapped
    }

    internal fun build(): RouteSpecHttp2RouteRetryPolicyArgs = RouteSpecHttp2RouteRetryPolicyArgs(
        httpRetryEvents = httpRetryEvents,
        maxRetries = maxRetries ?: throw PulumiNullFieldException("maxRetries"),
        perRetryTimeout = perRetryTimeout ?: throw PulumiNullFieldException("perRetryTimeout"),
        tcpRetryEvents = tcpRetryEvents,
    )
}
