@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class RouteSpecHttp2RouteTimeoutArgs(
    public val idle: Output<RouteSpecHttp2RouteTimeoutIdleArgs>? = null,
    public val perRequest: Output<RouteSpecHttp2RouteTimeoutPerRequestArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttp2RouteTimeoutArgs.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .perRequest(perRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecHttp2RouteTimeoutArgs].
 */
@PulumiTagMarker
public class RouteSpecHttp2RouteTimeoutArgsBuilder internal constructor() {
    private var idle: Output<RouteSpecHttp2RouteTimeoutIdleArgs>? = null

    private var perRequest: Output<RouteSpecHttp2RouteTimeoutPerRequestArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("gthhqajqelonehon")
    public suspend fun idle(`value`: Output<RouteSpecHttp2RouteTimeoutIdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("ebqmephspekuqvrv")
    public suspend fun perRequest(`value`: Output<RouteSpecHttp2RouteTimeoutPerRequestArgs>) {
        this.perRequest = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("xabdknbytxahplfs")
    public suspend fun idle(`value`: RouteSpecHttp2RouteTimeoutIdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("aekntgbcyumlaiah")
    public suspend fun idle(argument: suspend RouteSpecHttp2RouteTimeoutIdleArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteTimeoutIdleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("aojojybhhqktghqx")
    public suspend fun perRequest(`value`: RouteSpecHttp2RouteTimeoutPerRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perRequest = mapped
    }

    /**
     * @param argument Per request timeout.
     */
    @JvmName("sumynmxeqnyjqibc")
    public suspend
    fun perRequest(argument: suspend RouteSpecHttp2RouteTimeoutPerRequestArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttp2RouteTimeoutPerRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRequest = mapped
    }

    internal fun build(): RouteSpecHttp2RouteTimeoutArgs = RouteSpecHttp2RouteTimeoutArgs(
        idle = idle,
        perRequest = perRequest,
    )
}
