@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property weightedTargets Targets that traffic is routed to when a request matches the route.
 * You can specify one or more targets and their relative weights with which to distribute traffic.
 */
public data class RouteSpecHttpRouteActionArgs(
    public val weightedTargets: Output<List<RouteSpecHttpRouteActionWeightedTargetArgs>>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteActionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteActionArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteActionArgs.builder()
            .weightedTargets(
                weightedTargets.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RouteSpecHttpRouteActionArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteActionArgsBuilder internal constructor() {
    private var weightedTargets: Output<List<RouteSpecHttpRouteActionWeightedTargetArgs>>? = null

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("fgxksxfoemykwjvo")
    public suspend
    fun weightedTargets(`value`: Output<List<RouteSpecHttpRouteActionWeightedTargetArgs>>) {
        this.weightedTargets = value
    }

    @JvmName("wjaybgjrvriaketc")
    public suspend fun weightedTargets(
        vararg
        values: Output<RouteSpecHttpRouteActionWeightedTargetArgs>,
    ) {
        this.weightedTargets = Output.all(values.asList())
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("qiyyvvgdyaermnbd")
    public suspend
    fun weightedTargets(values: List<Output<RouteSpecHttpRouteActionWeightedTargetArgs>>) {
        this.weightedTargets = Output.all(values)
    }

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("aumdnebbcqqeorac")
    public suspend fun weightedTargets(`value`: List<RouteSpecHttpRouteActionWeightedTargetArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("flblrkwbhqelbbjb")
    public suspend
    fun weightedTargets(argument: List<suspend RouteSpecHttpRouteActionWeightedTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttpRouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("ymsnynugxemnavoh")
    public suspend fun weightedTargets(
        vararg
        argument: suspend RouteSpecHttpRouteActionWeightedTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttpRouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("jblwspvkyvtijorh")
    public suspend
    fun weightedTargets(argument: suspend RouteSpecHttpRouteActionWeightedTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecHttpRouteActionWeightedTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("juqgwnfdvkblimes")
    public suspend fun weightedTargets(vararg values: RouteSpecHttpRouteActionWeightedTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    internal fun build(): RouteSpecHttpRouteActionArgs = RouteSpecHttpRouteActionArgs(
        weightedTargets = weightedTargets ?: throw PulumiNullFieldException("weightedTargets"),
    )
}
