@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining an HTTP request match.
 * @property retryPolicy Retry policy.
 * @property timeout Types of timeouts.
 */
public data class RouteSpecHttpRouteArgs(
    public val action: Output<RouteSpecHttpRouteActionArgs>,
    public val match: Output<RouteSpecHttpRouteMatchArgs>,
    public val retryPolicy: Output<RouteSpecHttpRouteRetryPolicyArgs>? = null,
    public val timeout: Output<RouteSpecHttpRouteTimeoutArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeout(timeout?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecHttpRouteArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteArgsBuilder internal constructor() {
    private var action: Output<RouteSpecHttpRouteActionArgs>? = null

    private var match: Output<RouteSpecHttpRouteMatchArgs>? = null

    private var retryPolicy: Output<RouteSpecHttpRouteRetryPolicyArgs>? = null

    private var timeout: Output<RouteSpecHttpRouteTimeoutArgs>? = null

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("muasuxfpohwfgydl")
    public suspend fun action(`value`: Output<RouteSpecHttpRouteActionArgs>) {
        this.action = value
    }

    /**
     * @param value Criteria for determining an HTTP request match.
     */
    @JvmName("nwneilsfhpnjvnev")
    public suspend fun match(`value`: Output<RouteSpecHttpRouteMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Retry policy.
     */
    @JvmName("urreepmswqbbavhu")
    public suspend fun retryPolicy(`value`: Output<RouteSpecHttpRouteRetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("oreeicoxberlropm")
    public suspend fun timeout(`value`: Output<RouteSpecHttpRouteTimeoutArgs>) {
        this.timeout = value
    }

    /**
     * @param value Action to take if a match is determined.
     */
    @JvmName("rjldnqxbiyixvyeo")
    public suspend fun action(`value`: RouteSpecHttpRouteActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Action to take if a match is determined.
     */
    @JvmName("jwpvkvwxfmjhvhke")
    public suspend fun action(argument: suspend RouteSpecHttpRouteActionArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Criteria for determining an HTTP request match.
     */
    @JvmName("cnbjtoaedlmvjpww")
    public suspend fun match(`value`: RouteSpecHttpRouteMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining an HTTP request match.
     */
    @JvmName("hujcwsywruhjwtep")
    public suspend fun match(argument: suspend RouteSpecHttpRouteMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteMatchArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Retry policy.
     */
    @JvmName("rflydsutopveadal")
    public suspend fun retryPolicy(`value`: RouteSpecHttpRouteRetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument Retry policy.
     */
    @JvmName("kvheygmnbpeofsqs")
    public suspend
    fun retryPolicy(argument: suspend RouteSpecHttpRouteRetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteRetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value Types of timeouts.
     */
    @JvmName("mktcmkduwbcjetpb")
    public suspend fun timeout(`value`: RouteSpecHttpRouteTimeoutArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param argument Types of timeouts.
     */
    @JvmName("plluoqqdluvetren")
    public suspend fun timeout(argument: suspend RouteSpecHttpRouteTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteTimeoutArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeout = mapped
    }

    internal fun build(): RouteSpecHttpRouteArgs = RouteSpecHttpRouteArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        match = match ?: throw PulumiNullFieldException("match"),
        retryPolicy = retryPolicy,
        timeout = timeout,
    )
}
