@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property headers Client request headers to match on.
 * @property method Client request header method to match on. Valid values: `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`, `PATCH`.
 * @property path Client request path to match on.
 * @property port The port number to match from the request.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property queryParameters Client request query parameters to match on.
 * @property scheme Client request header scheme to match on. Valid values: `http`, `https`.
 */
public data class RouteSpecHttpRouteMatchArgs(
    public val headers: Output<List<RouteSpecHttpRouteMatchHeaderArgs>>? = null,
    public val method: Output<String>? = null,
    public val path: Output<RouteSpecHttpRouteMatchPathArgs>? = null,
    public val port: Output<Int>? = null,
    public val prefix: Output<String>? = null,
    public val queryParameters: Output<List<RouteSpecHttpRouteMatchQueryParameterArgs>>? = null,
    public val scheme: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchArgs.builder()
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .method(method?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .queryParameters(
                queryParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scheme(scheme?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttpRouteMatchArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteMatchArgsBuilder internal constructor() {
    private var headers: Output<List<RouteSpecHttpRouteMatchHeaderArgs>>? = null

    private var method: Output<String>? = null

    private var path: Output<RouteSpecHttpRouteMatchPathArgs>? = null

    private var port: Output<Int>? = null

    private var prefix: Output<String>? = null

    private var queryParameters: Output<List<RouteSpecHttpRouteMatchQueryParameterArgs>>? = null

    private var scheme: Output<String>? = null

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("tchlhduckmudjgyx")
    public suspend fun headers(`value`: Output<List<RouteSpecHttpRouteMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("pwcebjcevjdpngpm")
    public suspend fun headers(vararg values: Output<RouteSpecHttpRouteMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("xxewwtatfbrsxhgr")
    public suspend fun headers(values: List<Output<RouteSpecHttpRouteMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Client request header method to match on. Valid values: `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`, `PATCH`.
     */
    @JvmName("sarkafssyvugejvo")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("ebyhusyrxfjywwoh")
    public suspend fun path(`value`: Output<RouteSpecHttpRouteMatchPathArgs>) {
        this.path = value
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("lpcfjgwajjugquoo")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("gnayknqqkodirdtg")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("jnqfmjehbojnlatj")
    public suspend
    fun queryParameters(`value`: Output<List<RouteSpecHttpRouteMatchQueryParameterArgs>>) {
        this.queryParameters = value
    }

    @JvmName("iodmowxvygsvvgkk")
    public suspend fun queryParameters(
        vararg
        values: Output<RouteSpecHttpRouteMatchQueryParameterArgs>,
    ) {
        this.queryParameters = Output.all(values.asList())
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("iamaaejamwhrhwra")
    public suspend
    fun queryParameters(values: List<Output<RouteSpecHttpRouteMatchQueryParameterArgs>>) {
        this.queryParameters = Output.all(values)
    }

    /**
     * @param value Client request header scheme to match on. Valid values: `http`, `https`.
     */
    @JvmName("sykviqygsurwiqcx")
    public suspend fun scheme(`value`: Output<String>) {
        this.scheme = value
    }

    /**
     * @param value Client request headers to match on.
     */
    @JvmName("ggaplbhxasqfakgq")
    public suspend fun headers(`value`: List<RouteSpecHttpRouteMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("ctqmuqgnuoruuqdt")
    public suspend
    fun headers(argument: List<suspend RouteSpecHttpRouteMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttpRouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("roavuwotaetygijo")
    public suspend fun headers(
        vararg
        argument: suspend RouteSpecHttpRouteMatchHeaderArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttpRouteMatchHeaderArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Client request headers to match on.
     */
    @JvmName("arsqlmjmetpspkol")
    public suspend
    fun headers(argument: suspend RouteSpecHttpRouteMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecHttpRouteMatchHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Client request headers to match on.
     */
    @JvmName("ciakkcxcnxsfxtgk")
    public suspend fun headers(vararg values: RouteSpecHttpRouteMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Client request header method to match on. Valid values: `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`, `PATCH`.
     */
    @JvmName("xwryyytrlgqorljb")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Client request path to match on.
     */
    @JvmName("nydknilymxgfyjjv")
    public suspend fun path(`value`: RouteSpecHttpRouteMatchPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Client request path to match on.
     */
    @JvmName("cswhihppkfyxrsew")
    public suspend fun path(argument: suspend RouteSpecHttpRouteMatchPathArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteMatchPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    /**
     * @param value The port number to match from the request.
     */
    @JvmName("hbobeeraljihhqyb")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("lfxpeejqqfhmmssf")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Client request query parameters to match on.
     */
    @JvmName("mjfywekafpxucupy")
    public suspend fun queryParameters(`value`: List<RouteSpecHttpRouteMatchQueryParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("rhdjcrtbyalbpmns")
    public suspend
    fun queryParameters(argument: List<suspend RouteSpecHttpRouteMatchQueryParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttpRouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("kucfsroeelrbrkls")
    public suspend fun queryParameters(
        vararg
        argument: suspend RouteSpecHttpRouteMatchQueryParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteSpecHttpRouteMatchQueryParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Client request query parameters to match on.
     */
    @JvmName("felffolqojctldjn")
    public suspend
    fun queryParameters(argument: suspend RouteSpecHttpRouteMatchQueryParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecHttpRouteMatchQueryParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param values Client request query parameters to match on.
     */
    @JvmName("qqetjeugkejedvgk")
    public suspend fun queryParameters(vararg values: RouteSpecHttpRouteMatchQueryParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param value Client request header scheme to match on. Valid values: `http`, `https`.
     */
    @JvmName("nrdkmyvhqlwumqxl")
    public suspend fun scheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): RouteSpecHttpRouteMatchArgs = RouteSpecHttpRouteMatchArgs(
        headers = headers,
        method = method,
        path = path,
        port = port,
        prefix = prefix,
        queryParameters = queryParameters,
        scheme = scheme,
    )
}
