@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchHeaderMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property exact The exact path to match on.
 * @property prefix Header value sent by the client must begin with the specified characters.
 * @property range Object that specifies the range of numbers that the header value sent by the client must be included in.
 * @property regex The regex used to match the path.
 * @property suffix Header value sent by the client must end with the specified characters.
 */
public data class RouteSpecHttpRouteMatchHeaderMatchArgs(
    public val exact: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val range: Output<RouteSpecHttpRouteMatchHeaderMatchRangeArgs>? = null,
    public val regex: Output<String>? = null,
    public val suffix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchHeaderMatchArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchHeaderMatchArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchHeaderMatchArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .range(range?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regex(regex?.applyValue({ args0 -> args0 }))
            .suffix(suffix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttpRouteMatchHeaderMatchArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteMatchHeaderMatchArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    private var prefix: Output<String>? = null

    private var range: Output<RouteSpecHttpRouteMatchHeaderMatchRangeArgs>? = null

    private var regex: Output<String>? = null

    private var suffix: Output<String>? = null

    /**
     * @param value The exact path to match on.
     */
    @JvmName("pofbawvaejmqkgxi")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("tdjlbuifnryjocsg")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Object that specifies the range of numbers that the header value sent by the client must be included in.
     */
    @JvmName("djdpricopownjwie")
    public suspend fun range(`value`: Output<RouteSpecHttpRouteMatchHeaderMatchRangeArgs>) {
        this.range = value
    }

    /**
     * @param value The regex used to match the path.
     */
    @JvmName("xubqhhvhsynhpjgw")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value Header value sent by the client must end with the specified characters.
     */
    @JvmName("ypeibtqqiohkernd")
    public suspend fun suffix(`value`: Output<String>) {
        this.suffix = value
    }

    /**
     * @param value The exact path to match on.
     */
    @JvmName("gletciffcwiljkke")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value Header value sent by the client must begin with the specified characters.
     */
    @JvmName("lwbxfcoryckjjivs")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Object that specifies the range of numbers that the header value sent by the client must be included in.
     */
    @JvmName("vggcqscmbwhkascq")
    public suspend fun range(`value`: RouteSpecHttpRouteMatchHeaderMatchRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.range = mapped
    }

    /**
     * @param argument Object that specifies the range of numbers that the header value sent by the client must be included in.
     */
    @JvmName("rskvyqrylgmmgvuf")
    public suspend
    fun range(argument: suspend RouteSpecHttpRouteMatchHeaderMatchRangeArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteMatchHeaderMatchRangeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.range = mapped
    }

    /**
     * @param value The regex used to match the path.
     */
    @JvmName("mxigcvniddwtgxwc")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    /**
     * @param value Header value sent by the client must end with the specified characters.
     */
    @JvmName("crjceeluptykpxco")
    public suspend fun suffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffix = mapped
    }

    internal fun build(): RouteSpecHttpRouteMatchHeaderMatchArgs =
        RouteSpecHttpRouteMatchHeaderMatchArgs(
            exact = exact,
            prefix = prefix,
            range = range,
            regex = regex,
            suffix = suffix,
        )
}
