@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exact Header value sent by the client must match the specified value exactly.
 * @property regex Header value sent by the client must include the specified characters.
 */
public data class RouteSpecHttpRouteMatchPathArgs(
    public val exact: Output<String>? = null,
    public val regex: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchPathArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchPathArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchPathArgs.builder()
            .exact(exact?.applyValue({ args0 -> args0 }))
            .regex(regex?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttpRouteMatchPathArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteMatchPathArgsBuilder internal constructor() {
    private var exact: Output<String>? = null

    private var regex: Output<String>? = null

    /**
     * @param value Header value sent by the client must match the specified value exactly.
     */
    @JvmName("rnveqthjbndhhcln")
    public suspend fun exact(`value`: Output<String>) {
        this.exact = value
    }

    /**
     * @param value Header value sent by the client must include the specified characters.
     */
    @JvmName("oyhklknafukorypw")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value Header value sent by the client must match the specified value exactly.
     */
    @JvmName("kvrfjjpdhhslwxgo")
    public suspend fun exact(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exact = mapped
    }

    /**
     * @param value Header value sent by the client must include the specified characters.
     */
    @JvmName("ghjwwfkkfurtbvdu")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    internal fun build(): RouteSpecHttpRouteMatchPathArgs = RouteSpecHttpRouteMatchPathArgs(
        exact = exact,
        regex = regex,
    )
}
