@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property match Criteria for determining an gRPC request match.
 * @property name Name to use for the route. Must be between 1 and 255 characters in length.
 */
public data class RouteSpecHttpRouteMatchQueryParameterArgs(
    public val match: Output<RouteSpecHttpRouteMatchQueryParameterMatchArgs>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteMatchQueryParameterArgs.builder()
            .match(match?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttpRouteMatchQueryParameterArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteMatchQueryParameterArgsBuilder internal constructor() {
    private var match: Output<RouteSpecHttpRouteMatchQueryParameterMatchArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("lgfhwvncithyckbu")
    public suspend fun match(`value`: Output<RouteSpecHttpRouteMatchQueryParameterMatchArgs>) {
        this.match = value
    }

    /**
     * @param value Name to use for the route. Must be between 1 and 255 characters in length.
     */
    @JvmName("wltegkdltwfgeksu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Criteria for determining an gRPC request match.
     */
    @JvmName("swkkaavbosowblnv")
    public suspend fun match(`value`: RouteSpecHttpRouteMatchQueryParameterMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Criteria for determining an gRPC request match.
     */
    @JvmName("irwsctxrehlohrav")
    public suspend
    fun match(argument: suspend RouteSpecHttpRouteMatchQueryParameterMatchArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteMatchQueryParameterMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value Name to use for the route. Must be between 1 and 255 characters in length.
     */
    @JvmName("omusnxafyxjjrnvm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): RouteSpecHttpRouteMatchQueryParameterArgs =
        RouteSpecHttpRouteMatchQueryParameterArgs(
            match = match,
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
