@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property httpRetryEvents List of HTTP retry events.
 * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
 * @property maxRetries Maximum number of retries.
 * @property perRetryTimeout Per-retry timeout.
 * @property tcpRetryEvents List of TCP retry events. The only valid value is `connection-error`.
 */
public data class RouteSpecHttpRouteRetryPolicyArgs(
    public val httpRetryEvents: Output<List<String>>? = null,
    public val maxRetries: Output<Int>,
    public val perRetryTimeout: Output<RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs>,
    public val tcpRetryEvents: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyArgs.builder()
            .httpRetryEvents(httpRetryEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxRetries(maxRetries.applyValue({ args0 -> args0 }))
            .perRetryTimeout(perRetryTimeout.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tcpRetryEvents(tcpRetryEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RouteSpecHttpRouteRetryPolicyArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteRetryPolicyArgsBuilder internal constructor() {
    private var httpRetryEvents: Output<List<String>>? = null

    private var maxRetries: Output<Int>? = null

    private var perRetryTimeout: Output<RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs>? = null

    private var tcpRetryEvents: Output<List<String>>? = null

    /**
     * @param value List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("qvxiptvnixrcagnc")
    public suspend fun httpRetryEvents(`value`: Output<List<String>>) {
        this.httpRetryEvents = value
    }

    @JvmName("thhoqwxvyhwndhoj")
    public suspend fun httpRetryEvents(vararg values: Output<String>) {
        this.httpRetryEvents = Output.all(values.asList())
    }

    /**
     * @param values List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("tppsabwpenaivcqn")
    public suspend fun httpRetryEvents(values: List<Output<String>>) {
        this.httpRetryEvents = Output.all(values)
    }

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("gyxcbkggkjufvooh")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value Per-retry timeout.
     */
    @JvmName("yukfxxegfoxkrbed")
    public suspend
    fun perRetryTimeout(`value`: Output<RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs>) {
        this.perRetryTimeout = value
    }

    /**
     * @param value List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("uylmftebgkcxuwfn")
    public suspend fun tcpRetryEvents(`value`: Output<List<String>>) {
        this.tcpRetryEvents = value
    }

    @JvmName("ambmnyijwwnjlnhq")
    public suspend fun tcpRetryEvents(vararg values: Output<String>) {
        this.tcpRetryEvents = Output.all(values.asList())
    }

    /**
     * @param values List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("egsqdmlqbkkpkwes")
    public suspend fun tcpRetryEvents(values: List<Output<String>>) {
        this.tcpRetryEvents = Output.all(values)
    }

    /**
     * @param value List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("duubnosbhqpdnivn")
    public suspend fun httpRetryEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRetryEvents = mapped
    }

    /**
     * @param values List of HTTP retry events.
     * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
     */
    @JvmName("fslwuhfoeinifoxj")
    public suspend fun httpRetryEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpRetryEvents = mapped
    }

    /**
     * @param value Maximum number of retries.
     */
    @JvmName("porqubbiwmbduped")
    public suspend fun maxRetries(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value Per-retry timeout.
     */
    @JvmName("djhopiaehxddvwqn")
    public suspend fun perRetryTimeout(`value`: RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.perRetryTimeout = mapped
    }

    /**
     * @param argument Per-retry timeout.
     */
    @JvmName("axkbbsmjmlhtflkp")
    public suspend
    fun perRetryTimeout(argument: suspend RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRetryTimeout = mapped
    }

    /**
     * @param value List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("ahumypmblowuslei")
    public suspend fun tcpRetryEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpRetryEvents = mapped
    }

    /**
     * @param values List of TCP retry events. The only valid value is `connection-error`.
     */
    @JvmName("vvqqqguxqsrpptft")
    public suspend fun tcpRetryEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcpRetryEvents = mapped
    }

    internal fun build(): RouteSpecHttpRouteRetryPolicyArgs = RouteSpecHttpRouteRetryPolicyArgs(
        httpRetryEvents = httpRetryEvents,
        maxRetries = maxRetries ?: throw PulumiNullFieldException("maxRetries"),
        perRetryTimeout = perRetryTimeout ?: throw PulumiNullFieldException("perRetryTimeout"),
        tcpRetryEvents = tcpRetryEvents,
    )
}
