@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit Retry unit. Valid values: `ms`, `s`.
 * @property value Retry value.
 */
public data class RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs(
    public val unit: Output<String>,
    public val `value`: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs> {
    override fun toJava():
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs.builder()
            .unit(unit.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgsBuilder internal constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Retry unit. Valid values: `ms`, `s`.
     */
    @JvmName("cgilfjpcjdxoiacu")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Retry value.
     */
    @JvmName("wesdjsoruhjedlaa")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Retry unit. Valid values: `ms`, `s`.
     */
    @JvmName("iotdwoifnpjqmcee")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value Retry value.
     */
    @JvmName("tsdxnuexvfroitqf")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs =
        RouteSpecHttpRouteRetryPolicyPerRetryTimeoutArgs(
            unit = unit ?: throw PulumiNullFieldException("unit"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
