@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteTimeoutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property idle Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
 * @property perRequest Per request timeout.
 */
public data class RouteSpecHttpRouteTimeoutArgs(
    public val idle: Output<RouteSpecHttpRouteTimeoutIdleArgs>? = null,
    public val perRequest: Output<RouteSpecHttpRouteTimeoutPerRequestArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteTimeoutArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteTimeoutArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecHttpRouteTimeoutArgs.builder()
            .idle(idle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .perRequest(perRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RouteSpecHttpRouteTimeoutArgs].
 */
@PulumiTagMarker
public class RouteSpecHttpRouteTimeoutArgsBuilder internal constructor() {
    private var idle: Output<RouteSpecHttpRouteTimeoutIdleArgs>? = null

    private var perRequest: Output<RouteSpecHttpRouteTimeoutPerRequestArgs>? = null

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("rhdchgkpuxolempe")
    public suspend fun idle(`value`: Output<RouteSpecHttpRouteTimeoutIdleArgs>) {
        this.idle = value
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("mixoydtmlubcqttp")
    public suspend fun perRequest(`value`: Output<RouteSpecHttpRouteTimeoutPerRequestArgs>) {
        this.perRequest = value
    }

    /**
     * @param value Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("iymxlngjrhqmudms")
    public suspend fun idle(`value`: RouteSpecHttpRouteTimeoutIdleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idle = mapped
    }

    /**
     * @param argument Idle timeout. An idle timeout bounds the amount of time that a connection may be idle.
     */
    @JvmName("cbjuheyfqfkbydti")
    public suspend fun idle(argument: suspend RouteSpecHttpRouteTimeoutIdleArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteTimeoutIdleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.idle = mapped
    }

    /**
     * @param value Per request timeout.
     */
    @JvmName("vgotdapqtigmucmv")
    public suspend fun perRequest(`value`: RouteSpecHttpRouteTimeoutPerRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perRequest = mapped
    }

    /**
     * @param argument Per request timeout.
     */
    @JvmName("nbolypeytlfobdbq")
    public suspend
    fun perRequest(argument: suspend RouteSpecHttpRouteTimeoutPerRequestArgsBuilder.() -> Unit) {
        val toBeMapped = RouteSpecHttpRouteTimeoutPerRequestArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.perRequest = mapped
    }

    internal fun build(): RouteSpecHttpRouteTimeoutArgs = RouteSpecHttpRouteTimeoutArgs(
        idle = idle,
        perRequest = perRequest,
    )
}
