@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.inputs

import com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property weightedTargets Targets that traffic is routed to when a request matches the route.
 * You can specify one or more targets and their relative weights with which to distribute traffic.
 */
public data class RouteSpecTcpRouteActionArgs(
    public val weightedTargets: Output<List<RouteSpecTcpRouteActionWeightedTargetArgs>>,
) : ConvertibleToJava<com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionArgs> {
    override fun toJava(): com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionArgs =
        com.pulumi.aws.appmesh.inputs.RouteSpecTcpRouteActionArgs.builder()
            .weightedTargets(
                weightedTargets.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RouteSpecTcpRouteActionArgs].
 */
@PulumiTagMarker
public class RouteSpecTcpRouteActionArgsBuilder internal constructor() {
    private var weightedTargets: Output<List<RouteSpecTcpRouteActionWeightedTargetArgs>>? = null

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("fbdoopstmnnhlojw")
    public suspend
    fun weightedTargets(`value`: Output<List<RouteSpecTcpRouteActionWeightedTargetArgs>>) {
        this.weightedTargets = value
    }

    @JvmName("ehnqqohltwwsbtmf")
    public suspend fun weightedTargets(
        vararg
        values: Output<RouteSpecTcpRouteActionWeightedTargetArgs>,
    ) {
        this.weightedTargets = Output.all(values.asList())
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("bugaxwyyqmdutyvs")
    public suspend
    fun weightedTargets(values: List<Output<RouteSpecTcpRouteActionWeightedTargetArgs>>) {
        this.weightedTargets = Output.all(values)
    }

    /**
     * @param value Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("dexpeclasktaryuj")
    public suspend fun weightedTargets(`value`: List<RouteSpecTcpRouteActionWeightedTargetArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("squidprfxecsxcmc")
    public suspend
    fun weightedTargets(argument: List<suspend RouteSpecTcpRouteActionWeightedTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RouteSpecTcpRouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("qjkqdarbqrvfvfjt")
    public suspend fun weightedTargets(
        vararg
        argument: suspend RouteSpecTcpRouteActionWeightedTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RouteSpecTcpRouteActionWeightedTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param argument Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("lcmswkwgewawaduy")
    public suspend
    fun weightedTargets(argument: suspend RouteSpecTcpRouteActionWeightedTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RouteSpecTcpRouteActionWeightedTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.weightedTargets = mapped
    }

    /**
     * @param values Targets that traffic is routed to when a request matches the route.
     * You can specify one or more targets and their relative weights with which to distribute traffic.
     */
    @JvmName("wkedgyaawnnobhnr")
    public suspend fun weightedTargets(vararg values: RouteSpecTcpRouteActionWeightedTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedTargets = mapped
    }

    internal fun build(): RouteSpecTcpRouteActionArgs = RouteSpecTcpRouteActionArgs(
        weightedTargets = weightedTargets ?: throw PulumiNullFieldException("weightedTargets"),
    )
}
